/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.math.BigDecimal;
import org.drools.guvnor.client.common.NumericBigDecimalTextBox;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupNumericBigDecimalEditCell
extends AbstractPopupEditCell<BigDecimal, BigDecimal> {
    private final TextBox textBox = new NumericBigDecimalTextBox();

    public PopupNumericBigDecimalEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.textBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupNumericBigDecimalEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.textBox);
    }

    public void render(Cell.Context context, BigDecimal value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value.toPlainString()));
        }
    }

    @Override
    protected void commit() {
        String text = this.textBox.getValue();
        BigDecimal number = null;
        if (text.length() > 0) {
            try {
                number = new BigDecimal(text);
            }
            catch (NumberFormatException e) {
                number = new BigDecimal(0);
            }
        }
        this.setValue(this.lastContext, this.lastParent, number);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)number);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, BigDecimal value) {
        this.textBox.setValue((Object)(value == null ? "" : value.toPlainString()));
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupNumericBigDecimalEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupNumericBigDecimalEditCell.this.offsetX, parent.getAbsoluteTop() + PopupNumericBigDecimalEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        String text = PopupNumericBigDecimalEditCell.this.textBox.getValue();
                        PopupNumericBigDecimalEditCell.this.textBox.setFocus(true);
                        PopupNumericBigDecimalEditCell.this.textBox.setCursorPos(text.length());
                        PopupNumericBigDecimalEditCell.this.textBox.setSelectionRange(0, text.length());
                    }
                });
            }
        });
    }
}

