/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.BindingTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.OperatorSelection;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.ConditionColumnCommand;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class ConditionPopup
extends FormStylePopup {
    private SmallLabel patternLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private TextBox binding = new BindingTextBox();
    private Label operatorLabel = new Label();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private ImageButton editField;
    private ImageButton editOp;
    private RadioButton literal = new RadioButton("constraintValueType", Constants.INSTANCE.LiteralValue());
    private RadioButton formula = new RadioButton("constraintValueType", Constants.INSTANCE.Formula());
    private RadioButton predicate = new RadioButton("constraintValueType", Constants.INSTANCE.Predicate());
    private CEPWindowOperatorsDropdown cwo;
    private TextBox entryPointName;
    private int cepWindowRowIndex;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;
    private final DTCellValueWidgetFactory factory;
    private final Validator validator;
    private final BRLRuleModel rm;
    private final DTCellValueUtilities utilities;
    private Pattern52 editingPattern;
    private ConditionCol52 editingCol;
    private final boolean isReadOnly;
    private InfoPopup fieldLabelInterpolationInfo = this.getPredicateHint();

    public ConditionPopup(SuggestionCompletionEngine sce, final GuidedDecisionTable52 model, final ConditionColumnCommand refreshGrid, final ConditionCol52 col, final boolean isNew, boolean isReadOnly) {
        this.rm = new BRLRuleModel(model);
        this.editingPattern = model.getPattern(col);
        this.editingCol = this.cloneConditionColumn(col);
        this.model = model;
        this.sce = sce;
        this.isReadOnly = isReadOnly;
        this.validator = new Validator(model.getConditions());
        this.utilities = new DTCellValueUtilities(model, sce);
        this.factory = DTCellValueWidgetFactory.getInstance(model, sce, isReadOnly, this.allowEmptyValues());
        this.setTitle(Constants.INSTANCE.ConditionColumnConfiguration());
        this.setModal(false);
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.patternLabel);
        this.doPatternLabel();
        ImageButton changePattern = new ImageButton(GuvnorImages.INSTANCE.Edit(), DroolsGuvnorImages.INSTANCE.EditDisabled(), Constants.INSTANCE.ChooseAnExistingPatternThatThisColumnAddsTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showChangePattern(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(Constants.INSTANCE.Pattern(), (Widget)pattern);
        switch (model.getTableFormat()) {
            case EXTENDED_ENTRY: {
                HorizontalPanel valueTypes = new HorizontalPanel();
                valueTypes.add((Widget)this.literal);
                valueTypes.add((Widget)this.formula);
                valueTypes.add((Widget)this.predicate);
                this.addAttribute(Constants.INSTANCE.CalculationType(), (Widget)valueTypes);
                switch (this.editingCol.getConstraintValueType()) {
                    case 1: {
                        this.literal.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(!isReadOnly);
                        break;
                    }
                    case 3: {
                        this.formula.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.predicate.setValue(Boolean.valueOf(true));
                        this.binding.setEnabled(false);
                    }
                }
                if (!isReadOnly) {
                    this.literal.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent w) {
                            ConditionPopup.this.editingCol.setFactField(null);
                            ConditionPopup.this.applyConsTypeChange(1);
                        }
                    });
                }
                if (!isReadOnly) {
                    this.formula.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent w) {
                            ConditionPopup.this.editingCol.setFactField(null);
                            ConditionPopup.this.applyConsTypeChange(3);
                        }
                    });
                }
                if (!isReadOnly) {
                    this.predicate.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent w) {
                            ConditionPopup.this.editingCol.setFactField(null);
                            ConditionPopup.this.applyConsTypeChange(5);
                        }
                    });
                }
                this.doCalculationType();
                break;
            }
            case LIMITED_ENTRY: {
                this.binding.setEnabled(!isReadOnly);
            }
        }
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        field.add((Widget)this.fieldLabelInterpolationInfo);
        this.editField = new ImageButton(GuvnorImages.INSTANCE.Edit(), DroolsGuvnorImages.INSTANCE.EditDisabled(), Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showFieldChange();
            }
        });
        this.editField.setEnabled(!isReadOnly);
        field.add((Widget)this.editField);
        this.addAttribute(Constants.INSTANCE.Field(), (Widget)field);
        this.doFieldLabel();
        HorizontalPanel operator = new HorizontalPanel();
        operator.add((Widget)this.operatorLabel);
        this.editOp = new ImageButton(GuvnorImages.INSTANCE.Edit(), DroolsGuvnorImages.INSTANCE.EditDisabled(), Constants.INSTANCE.EditTheOperatorThatIsUsedToCompareDataWithThisField(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.showOperatorChange();
            }
        });
        this.editOp.setEnabled(!isReadOnly);
        operator.add((Widget)this.editOp);
        this.addAttribute(Constants.INSTANCE.Operator(), (Widget)operator);
        this.doOperatorLabel();
        this.doImageButtons();
        this.cepWindowRowIndex = this.addAttribute(Constants.INSTANCE.DTLabelOverCEPWindow(), this.createCEPWindowWidget((HasCEPWindow)this.editingPattern));
        this.displayCEPOperators();
        this.entryPointName = new TextBox();
        this.entryPointName.setText(this.editingPattern.getEntryPointName());
        this.entryPointName.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            this.entryPointName.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingPattern.setEntryPointName(ConditionPopup.this.entryPointName.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.DTLabelFromEntryPoint(), (Widget)this.entryPointName);
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (Widget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ConditionPopup.this.editingCol.setValueList(ConditionPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ConditionPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(model.getValueList((BaseColumn)ConditionPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ConditionPopup.this.utilities.asString(ConditionPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ConditionPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ConditionPopup.this.editingCol.getDefaultValue();
                            DTDataTypes52 dataType = ConditionPopup.this.utilities.getDataType(ConditionPopup.this.editingPattern, ConditionPopup.this.editingCol);
                            ConditionPopup.this.utilities.assertDTCellValue(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((Widget)new InfoPopup(Constants.INSTANCE.ValueList(), Constants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(Constants.INSTANCE.optionalValueList(), (Widget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(Constants.INSTANCE.DefaultValue(), (Widget)this.defaultValueWidgetContainer);
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(Constants.INSTANCE.LimitedEntryValue(), (Widget)this.limitedEntryValueWidgetContainer);
            this.makeLimitedValueWidget();
        }
        this.binding.setText(col.getBinding());
        if (!isReadOnly) {
            this.binding.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ConditionPopup.this.editingCol.setBinding(ConditionPopup.this.binding.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.Binding(), (Widget)this.binding);
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (Widget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (null == ConditionPopup.this.editingCol.getHeader() || "".equals(ConditionPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
                    return;
                }
                if (ConditionPopup.this.editingCol.getConstraintValueType() != 5) {
                    if (null == ConditionPopup.this.editingCol.getFactField() || "".equals(ConditionPopup.this.editingCol.getFactField())) {
                        Window.alert((String)Constants.INSTANCE.PleaseSelectOrEnterField());
                        return;
                    }
                    if (null == ConditionPopup.this.editingCol.getOperator() || "".equals(ConditionPopup.this.editingCol.getOperator())) {
                        Window.alert((String)Constants.INSTANCE.NotifyNoSelectedOperator());
                    }
                } else {
                    ConditionPopup.this.editingCol.setOperator(null);
                }
                if (ConditionPopup.this.editingCol.isBound() && !ConditionPopup.this.isBindingUnique(ConditionPopup.this.editingCol.getBinding())) {
                    Window.alert((String)Constants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                    return;
                }
                if (isNew) {
                    if (!ConditionPopup.this.unique(ConditionPopup.this.editingCol.getHeader())) {
                        Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                        return;
                    }
                } else if (!col.getHeader().equals(ConditionPopup.this.editingCol.getHeader()) && !ConditionPopup.this.unique(ConditionPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                    return;
                }
                if (ConditionPopup.this.editingCol.getConstraintValueType() != 1) {
                    ConditionPopup.this.editingCol.setBinding(null);
                }
                refreshGrid.execute(ConditionPopup.this.editingPattern, ConditionPopup.this.editingCol);
                ConditionPopup.this.hide();
            }
        });
        this.addAttribute("", (Widget)apply);
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ConditionCol52 cloneConditionColumn(ConditionCol52 col) {
        LimitedEntryConditionCol52 clone = null;
        if (col instanceof LimitedEntryConditionCol52) {
            clone = new LimitedEntryConditionCol52();
            DTCellValue52 dcv = this.cloneLimitedEntryValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ConditionCol52();
        }
        clone.setConstraintValueType(col.getConstraintValueType());
        clone.setFactField(col.getFactField());
        clone.setFieldType(col.getFieldType());
        clone.setHeader(col.getHeader());
        clone.setOperator(col.getOperator());
        clone.setValueList(col.getValueList());
        clone.setDefaultValue(new DTCellValue52(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        clone.setParameters(col.getParameters());
        clone.setWidth(col.getWidth());
        clone.setBinding(col.getBinding());
        return clone;
    }

    private DTCellValue52 cloneLimitedEntryValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryConditionCol52)) {
            return;
        }
        LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)this.editingCol;
        boolean doesOperatorNeedValue = this.validator.doesOperatorNeedValue(this.editingCol);
        if (!doesOperatorNeedValue) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            lec.setValue(null);
            return;
        }
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lec.getValue() == null) {
            lec.setValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, lec.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        if (!this.validator.doesOperatorNeedValue(this.editingCol)) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue(this.editingPattern, this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DTDataTypes52 dataType = this.utilities.getDataType(this.editingPattern, this.editingCol);
        this.utilities.assertDTCellValue(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.editingPattern, this.editingCol, defaultValue));
    }

    private void applyConsTypeChange(int newType) {
        this.editingCol.setConstraintValueType(newType);
        this.binding.setEnabled(newType == 1 && !this.isReadOnly);
        this.doFieldLabel();
        this.doValueList();
        this.doOperatorLabel();
        this.doImageButtons();
        this.makeDefaultValueWidget();
    }

    private void doImageButtons() {
        int constraintType = this.editingCol.getConstraintValueType();
        this.editField.setEnabled(constraintType != 5 && !this.isReadOnly);
        this.editOp.setEnabled(constraintType != 5 && !this.isReadOnly);
    }

    private boolean isBindingUnique(String binding) {
        return !this.rm.isVariableNameUsed(binding);
    }

    private void doFieldLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            if (this.editingCol.getFactField() == null || this.editingCol.getFactField().equals("")) {
                this.fieldLabel.setText(Constants.INSTANCE.notNeededForPredicate());
            } else {
                this.fieldLabel.setText(this.editingCol.getFactField());
            }
            this.fieldLabelInterpolationInfo.setVisible(true);
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseSelectAPatternFirst());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else if (this.nil(this.editingCol.getFactField())) {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseSelectAField());
            this.fieldLabelInterpolationInfo.setVisible(false);
        } else {
            this.fieldLabel.setText(this.editingCol.getFactField());
        }
    }

    private void doOperatorLabel() {
        if (this.editingCol.getConstraintValueType() == 5) {
            this.operatorLabel.setText(Constants.INSTANCE.notNeededForPredicate());
        } else if (this.nil(this.editingPattern.getFactType())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseSelectAPatternFirst());
        } else if (this.nil(this.editingCol.getFactField())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseChooseAFieldFirst());
        } else if (this.nil(this.editingCol.getOperator())) {
            this.operatorLabel.setText(Constants.INSTANCE.pleaseSelectAField());
        } else {
            this.operatorLabel.setText(HumanReadable.getOperatorDisplayName(this.editingCol.getOperator()));
        }
    }

    private void doPatternLabel() {
        if (this.editingPattern.getFactType() != null) {
            StringBuilder patternLabel = new StringBuilder();
            String factType = this.editingPattern.getFactType();
            String boundName = this.editingPattern.getBoundName();
            if (factType != null && factType.length() > 0) {
                if (this.editingPattern.isNegated()) {
                    patternLabel.append(Constants.INSTANCE.negatedPattern()).append(" ").append(factType);
                } else {
                    patternLabel.append(factType).append(" [").append(boundName).append("]");
                }
            }
            this.patternLabel.setText(patternLabel.toString());
        }
        this.doFieldLabel();
        this.doOperatorLabel();
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ConditionPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private InfoPopup getPredicateHint() {
        return new InfoPopup(Constants.INSTANCE.Predicates(), Constants.INSTANCE.PredicatesInfo());
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = this.validator.doesOperatorAcceptValueList(this.editingCol);
        }
        if (enableValueList) {
            enableValueList = !this.sce.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private void doCalculationType() {
        String factField;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.editingPattern.getFactType();
        boolean hasEnums = this.sce.hasEnums(factType, factField = this.editingCol.getFactField());
        this.literal.setEnabled(hasEnums || !this.isReadOnly);
        this.formula.setEnabled(!hasEnums && !this.isReadOnly);
        this.predicate.setEnabled(!hasEnums && !this.isReadOnly);
        if (hasEnums) {
            this.editingCol.setConstraintValueType(1);
        }
    }

    private ListBox loadPatterns() {
        HashSet<String> vars = new HashSet<String>();
        ListBox patterns = new ListBox();
        for (Pattern52 p : this.model.getPatterns()) {
            if (vars.contains(p.getBoundName())) continue;
            patterns.addItem((p.isNegated() ? Constants.INSTANCE.negatedPattern() + " " : "") + p.getFactType() + " [" + p.getBoundName() + "]", p.getFactType() + " " + p.getBoundName() + " " + p.isNegated());
            vars.add(p.getBoundName());
        }
        return patterns;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showOperatorChange() {
        final FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.SetTheOperator());
        pop.setModal(false);
        String factType = this.editingPattern.getFactType();
        String factField = this.editingCol.getFactField();
        String[] ops = this.sce.getOperatorCompletions(factType, factField);
        ArrayList<String> filteredOps = new ArrayList<String>();
        for (String op : ops) {
            filteredOps.add(op);
        }
        if (1 != this.editingCol.getConstraintValueType()) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        if (this.sce.hasEnums(factType, factField)) {
            filteredOps.remove("in");
            filteredOps.remove("not in");
        }
        String[] displayOps = new String[filteredOps.size()];
        filteredOps.toArray(displayOps);
        final CEPOperatorsDropdown box = new CEPOperatorsDropdown(displayOps, (HasParameterizedOperator)this.editingCol);
        box.addItem(Constants.INSTANCE.noOperator(), "");
        pop.addAttribute(Constants.INSTANCE.Operator(), (Widget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.editingCol.setOperator(box.getValue(box.getSelectedIndex()));
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.doOperatorLabel();
                ConditionPopup.this.doValueList();
                pop.hide();
            }
        });
        pop.show();
    }

    private boolean unique(String header) {
        for (CompositeColumn cc : this.model.getConditions()) {
            for (int iChild = 0; iChild < cc.getChildColumns().size(); ++iChild) {
                if (!((BaseColumn)cc.getChildColumns().get(iChild)).getHeader().equals(header)) continue;
                return false;
            }
        }
        return true;
    }

    protected void showChangePattern(ClickEvent w) {
        final ListBox pats = this.loadPatterns();
        if (pats.getItemCount() == 0) {
            this.showNewPatternDialog();
            return;
        }
        final FormStylePopup pop = new FormStylePopup();
        Button ok = new Button(Constants.INSTANCE.OK());
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)pats);
        hp.add((Widget)ok);
        pop.addAttribute(Constants.INSTANCE.ChooseExistingPatternToAddColumnTo(), (Widget)hp);
        pop.addAttribute("", (Widget)new HTML(Constants.INSTANCE.ORwithEmphasis()));
        Button createPattern = new Button(Constants.INSTANCE.CreateNewFactPattern());
        createPattern.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                pop.hide();
                ConditionPopup.this.showNewPatternDialog();
            }
        });
        pop.addAttribute("", (Widget)createPattern);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String[] val = pats.getValue(pats.getSelectedIndex()).split("\\s");
                ConditionPopup.this.editingPattern = ConditionPopup.this.model.getConditionPattern(val[1]);
                ConditionPopup.this.editingCol.setFactField(null);
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.entryPointName.setText(ConditionPopup.this.editingPattern.getEntryPointName());
                ConditionPopup.this.cwo.selectItem(ConditionPopup.this.editingPattern.getWindow().getOperator());
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.displayCEPOperators();
                ConditionPopup.this.doPatternLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                pop.hide();
            }
        });
        pop.show();
    }

    protected void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        String[] fields = this.sce.getFieldCompletions(FieldAccessorsAndMutators.ACCESSOR, this.editingPattern.getFactType());
        final ListBox box = new ListBox();
        switch (this.editingCol.getConstraintValueType()) {
            case 1: {
                int i;
                for (i = 0; i < fields.length; ++i) {
                    box.addItem(fields[i]);
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < fields.length; ++i) {
                    if (this.sce.hasEnums(this.editingPattern.getFactType(), fields[i])) continue;
                    box.addItem(fields[i]);
                }
                break;
            }
        }
        pop.addAttribute(Constants.INSTANCE.Field(), (Widget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ConditionPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ConditionPopup.this.editingCol.setFieldType(ConditionPopup.this.sce.getFieldType(ConditionPopup.this.editingPattern.getFactType(), ConditionPopup.this.editingCol.getFactField()));
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.doFieldLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.doOperatorLabel();
                pop.hide();
            }
        });
        pop.show();
    }

    protected void showNewPatternDialog() {
        FormStylePopup pop = new FormStylePopup();
        pop.setTitle(Constants.INSTANCE.CreateANewFactPattern());
        final ListBox types = new ListBox();
        for (int i = 0; i < this.sce.getFactTypes().length; ++i) {
            types.addItem(this.sce.getFactTypes()[i]);
        }
        pop.addAttribute(Constants.INSTANCE.FactType(), (Widget)types);
        BindingTextBox binding = new BindingTextBox();
        binding.addChangeHandler(new ChangeHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onChange(ChangeEvent event) {
                this.val$binding.setText(this.val$binding.getText().replace(" ", ""));
            }
        });
        pop.addAttribute(Constants.INSTANCE.Binding(), (Widget)binding);
        final CheckBox chkNegated = new CheckBox();
        chkNegated.addClickHandler(new ClickHandler((TextBox)binding){
            final /* synthetic */ TextBox val$binding;
            {
                this.val$binding = textBox;
            }

            public void onClick(ClickEvent event) {
                boolean isPatternNegated = chkNegated.getValue();
                this.val$binding.setEnabled(!isPatternNegated);
            }
        });
        pop.addAttribute(Constants.INSTANCE.negatePattern(), (Widget)chkNegated);
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler((TextBox)binding, pop){
            final /* synthetic */ TextBox val$binding;
            final /* synthetic */ FormStylePopup val$pop;
            {
                this.val$binding = textBox;
                this.val$pop = formStylePopup;
            }

            public void onClick(ClickEvent w) {
                String fn;
                boolean isPatternNegated = chkNegated.getValue();
                String ft = types.getItemText(types.getSelectedIndex());
                String string = fn = isPatternNegated ? "" : this.val$binding.getText();
                if (!isPatternNegated) {
                    if (fn.equals("")) {
                        Window.alert((String)Constants.INSTANCE.PleaseEnterANameForFact());
                        return;
                    }
                    if (fn.equals(ft)) {
                        Window.alert((String)Constants.INSTANCE.PleaseEnterANameThatIsNotTheSameAsTheFactType());
                        return;
                    }
                    if (!ConditionPopup.this.isBindingUnique(fn)) {
                        Window.alert((String)Constants.INSTANCE.PleaseEnterANameThatIsNotAlreadyUsedByAnotherPattern());
                        return;
                    }
                }
                ConditionPopup.this.editingPattern = new Pattern52();
                ConditionPopup.this.editingPattern.setFactType(ft);
                ConditionPopup.this.editingPattern.setBoundName(fn);
                ConditionPopup.this.editingPattern.setNegated(isPatternNegated);
                ConditionPopup.this.editingCol.setFactField(null);
                ConditionPopup.this.editingCol.setOperator(null);
                ConditionPopup.this.entryPointName.setText(ConditionPopup.this.editingPattern.getEntryPointName());
                ConditionPopup.this.cwo.selectItem(ConditionPopup.this.editingPattern.getWindow().getOperator());
                ConditionPopup.this.makeLimitedValueWidget();
                ConditionPopup.this.makeDefaultValueWidget();
                ConditionPopup.this.displayCEPOperators();
                ConditionPopup.this.doPatternLabel();
                ConditionPopup.this.doValueList();
                ConditionPopup.this.doCalculationType();
                ConditionPopup.this.doOperatorLabel();
                this.val$pop.hide();
            }
        });
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private Widget createCEPWindowWidget(final HasCEPWindow c) {
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(Constants.INSTANCE.OverCEPWindow());
        lbl.setStyleName("paddedLabel");
        hp.add((Widget)lbl);
        this.cwo = new CEPWindowOperatorsDropdown(c, this.isReadOnly);
        if (!this.isReadOnly) {
            this.cwo.addValueChangeHandler(new ValueChangeHandler<OperatorSelection>(){

                public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                    OperatorSelection selection = (OperatorSelection)event.getValue();
                    String selected = selection.getValue();
                    c.getWindow().setOperator(selected);
                }
            });
        }
        hp.add((Widget)this.cwo);
        return hp;
    }

    private void displayCEPOperators() {
        boolean isVisible = this.sce.isFactTypeAnEvent(this.editingPattern.getFactType());
        this.setAttributeVisibility(this.cepWindowRowIndex, isVisible);
    }
}

