/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.GenericColumnCommand;
import org.drools.guvnor.client.decisiontable.widget.DTCellValueUtilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BRLRuleModel;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTColumnConfig52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;

public class ActionSetFieldPopup
extends FormStylePopup {
    private SmallLabel bindingLabel = new SmallLabel();
    private TextBox fieldLabel = this.getFieldLabel();
    private SimplePanel limitedEntryValueWidgetContainer = new SimplePanel();
    private int limitedEntryValueAttributeIndex = -1;
    private TextBox valueListWidget = null;
    private SimplePanel defaultValueWidgetContainer = new SimplePanel();
    private int defaultValueWidgetContainerIndex = -1;
    private final GuidedDecisionTable52 model;
    private final SuggestionCompletionEngine sce;
    private final DTCellValueWidgetFactory factory;
    private final BRLRuleModel rm;
    private final DTCellValueUtilities utilities;
    private ActionSetFieldCol52 editingCol;
    private final boolean isReadOnly;

    public ActionSetFieldPopup(SuggestionCompletionEngine sce, final GuidedDecisionTable52 model, final GenericColumnCommand refreshGrid, final ActionSetFieldCol52 col, final boolean isNew, boolean isReadOnly) {
        this.rm = new BRLRuleModel(model);
        this.editingCol = this.cloneActionSetColumn(col);
        this.model = model;
        this.sce = sce;
        this.isReadOnly = isReadOnly;
        this.utilities = new DTCellValueUtilities(model, sce);
        this.factory = DTCellValueWidgetFactory.getInstance(model, sce, isReadOnly, this.allowEmptyValues());
        this.setTitle(Constants.INSTANCE.ColumnConfigurationSetAFieldOnAFact());
        this.setModal(false);
        HorizontalPanel pattern = new HorizontalPanel();
        pattern.add((Widget)this.bindingLabel);
        this.doBindingLabel();
        ImageButton changePattern = new ImageButton(this.createEnabledEditButton(), this.createDisabledEditButton(), Constants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionSetFieldPopup.this.showChangeFact(w);
            }
        });
        changePattern.setEnabled(!isReadOnly);
        pattern.add((Widget)changePattern);
        this.addAttribute(Constants.INSTANCE.Fact(), (Widget)pattern);
        HorizontalPanel field = new HorizontalPanel();
        this.fieldLabel.setEnabled(!isReadOnly);
        field.add((Widget)this.fieldLabel);
        ImageButton editField = new ImageButton(this.createEnabledEditButton(), this.createDisabledEditButton(), Constants.INSTANCE.EditTheFieldThatThisColumnOperatesOn(), new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionSetFieldPopup.this.showFieldChange();
            }
        });
        editField.setEnabled(!isReadOnly);
        field.add((Widget)editField);
        this.addAttribute(Constants.INSTANCE.Field(), (Widget)field);
        this.doFieldLabel();
        final TextBox header = new TextBox();
        header.setText(col.getHeader());
        header.setEnabled(!isReadOnly);
        if (!isReadOnly) {
            header.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ActionSetFieldPopup.this.editingCol.setHeader(header.getText());
                }
            });
        }
        this.addAttribute(Constants.INSTANCE.ColumnHeaderDescription(), (Widget)header);
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.valueListWidget = new TextBox();
            this.valueListWidget.setText(this.editingCol.getValueList());
            this.valueListWidget.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                this.valueListWidget.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        ActionSetFieldPopup.this.editingCol.setValueList(ActionSetFieldPopup.this.valueListWidget.getText());
                    }
                });
                this.valueListWidget.addBlurHandler(new BlurHandler(){

                    public void onBlur(BlurEvent event) {
                        this.assertDefaultValue();
                        ActionSetFieldPopup.this.makeDefaultValueWidget();
                    }

                    private void assertDefaultValue() {
                        List<String> valueList = Arrays.asList(model.getValueList((BaseColumn)ActionSetFieldPopup.this.editingCol));
                        if (valueList.size() > 0) {
                            String defaultValue = ActionSetFieldPopup.this.utilities.asString(ActionSetFieldPopup.this.editingCol.getDefaultValue());
                            if (!valueList.contains(defaultValue)) {
                                ActionSetFieldPopup.this.editingCol.getDefaultValue().clearValues();
                            }
                        } else {
                            DTCellValue52 defaultValue = ActionSetFieldPopup.this.editingCol.getDefaultValue();
                            DTDataTypes52 dataType = ActionSetFieldPopup.this.utilities.getDataType((BaseColumn)ActionSetFieldPopup.this.editingCol);
                            ActionSetFieldPopup.this.utilities.assertDTCellValue(dataType, defaultValue);
                        }
                    }
                });
            }
            HorizontalPanel vl = new HorizontalPanel();
            vl.add((Widget)this.valueListWidget);
            vl.add((Widget)new InfoPopup(Constants.INSTANCE.ValueList(), Constants.INSTANCE.ValueListsExplanation()));
            this.addAttribute(Constants.INSTANCE.optionalValueList(), (Widget)vl);
        }
        this.doValueList();
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            this.defaultValueWidgetContainerIndex = this.addAttribute(Constants.INSTANCE.DefaultValue(), (Widget)this.defaultValueWidgetContainer);
            this.makeDefaultValueWidget();
        }
        if (model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            this.limitedEntryValueAttributeIndex = this.addAttribute(Constants.INSTANCE.LimitedEntryValue(), (Widget)this.limitedEntryValueWidgetContainer);
            this.makeLimitedValueWidget();
        }
        this.addAttribute(Constants.INSTANCE.UpdateEngineWithChanges(), this.doUpdate());
        this.addAttribute(Constants.INSTANCE.HideThisColumn(), (Widget)DTCellValueWidgetFactory.getHideColumnIndicator((DTColumnConfig52)this.editingCol));
        Button apply = new Button(Constants.INSTANCE.ApplyChanges());
        apply.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (!ActionSetFieldPopup.this.isValidFactType()) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnFact());
                    return;
                }
                if (!ActionSetFieldPopup.this.isValidFactField()) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnField());
                    return;
                }
                if (null == ActionSetFieldPopup.this.editingCol.getHeader() || "".equals(ActionSetFieldPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.YouMustEnterAColumnHeaderValueDescription());
                    return;
                }
                if (isNew) {
                    if (!ActionSetFieldPopup.this.unique(ActionSetFieldPopup.this.editingCol.getHeader())) {
                        Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                        return;
                    }
                } else if (!col.getHeader().equals(ActionSetFieldPopup.this.editingCol.getHeader()) && !ActionSetFieldPopup.this.unique(ActionSetFieldPopup.this.editingCol.getHeader())) {
                    Window.alert((String)Constants.INSTANCE.ThatColumnNameIsAlreadyInUsePleasePickAnother());
                    return;
                }
                refreshGrid.execute((DTColumnConfig52)ActionSetFieldPopup.this.editingCol);
                ActionSetFieldPopup.this.hide();
            }
        });
        this.addAttribute("", (Widget)apply);
    }

    private Image createDisabledEditButton() {
        Image disabledChangePattern = DroolsGuvnorImages.INSTANCE.EditDisabled();
        disabledChangePattern.setAltText(Constants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        return disabledChangePattern;
    }

    private Image createEnabledEditButton() {
        Image enabledChangePattern = GuvnorImages.INSTANCE.Edit();
        enabledChangePattern.setAltText(Constants.INSTANCE.ChooseABoundFactThatThisColumnPertainsTo());
        return enabledChangePattern;
    }

    private boolean allowEmptyValues() {
        return this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    private ActionSetFieldCol52 cloneActionSetColumn(ActionSetFieldCol52 col) {
        LimitedEntryActionSetFieldCol52 clone = null;
        if (col instanceof LimitedEntryActionSetFieldCol52) {
            clone = new LimitedEntryActionSetFieldCol52();
            DTCellValue52 dcv = this.cloneLimitedEntryValue(((LimitedEntryCol)col).getValue());
            ((LimitedEntryCol)clone).setValue(dcv);
        } else {
            clone = new ActionSetFieldCol52();
        }
        clone.setBoundName(col.getBoundName());
        clone.setFactField(col.getFactField());
        clone.setHeader(col.getHeader());
        clone.setType(col.getType());
        clone.setValueList(col.getValueList());
        clone.setUpdate(col.isUpdate());
        clone.setDefaultValue(new DTCellValue52(col.getDefaultValue()));
        clone.setHideColumn(col.isHideColumn());
        return clone;
    }

    private DTCellValue52 cloneLimitedEntryValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        DTCellValue52 clone = new DTCellValue52(dcv);
        return clone;
    }

    private void makeLimitedValueWidget() {
        if (!(this.editingCol instanceof LimitedEntryActionSetFieldCol52)) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, false);
            return;
        }
        LimitedEntryActionSetFieldCol52 lea = (LimitedEntryActionSetFieldCol52)this.editingCol;
        this.setAttributeVisibility(this.limitedEntryValueAttributeIndex, true);
        if (lea.getValue() == null) {
            lea.setValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        this.limitedEntryValueWidgetContainer.setWidget(this.factory.getWidget(this.model.getConditionPattern(this.editingCol.getBoundName()), this.editingCol, lea.getValue()));
    }

    private void makeDefaultValueWidget() {
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        if (this.nil(this.editingCol.getFactField())) {
            this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, false);
            return;
        }
        this.setAttributeVisibility(this.defaultValueWidgetContainerIndex, true);
        if (this.editingCol.getDefaultValue() == null) {
            this.editingCol.setDefaultValue(this.factory.makeNewValue((DTColumnConfig52)this.editingCol));
        }
        DTCellValue52 defaultValue = this.editingCol.getDefaultValue();
        DTDataTypes52 dataType = this.utilities.getDataType((BaseColumn)this.editingCol);
        this.utilities.assertDTCellValue(dataType, defaultValue);
        this.defaultValueWidgetContainer.setWidget(this.factory.getWidget(this.model.getConditionPattern(this.editingCol.getBoundName()), this.editingCol, defaultValue));
    }

    private void doBindingLabel() {
        if (this.editingCol.getBoundName() != null) {
            this.bindingLabel.setText("" + this.editingCol.getBoundName());
        } else {
            this.bindingLabel.setText(Constants.INSTANCE.pleaseChooseABoundFactForThisColumn());
        }
    }

    private void doFieldLabel() {
        if (this.editingCol.getFactField() != null) {
            this.fieldLabel.setText(this.editingCol.getFactField());
        } else {
            this.fieldLabel.setText(Constants.INSTANCE.pleaseChooseAFactPatternFirst());
        }
    }

    private void doValueList() {
        boolean enableValueList;
        if (this.model.getTableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return;
        }
        String factType = this.model.getBoundFactType(this.editingCol.getBoundName());
        String factField = this.editingCol.getFactField();
        boolean bl = enableValueList = factType != null && !"".equals(factType) && factField != null && !"".equals(factField);
        if (enableValueList) {
            enableValueList = !this.sce.hasEnums(factType, factField);
        }
        this.valueListWidget.setEnabled(enableValueList);
        if (!enableValueList) {
            this.valueListWidget.setText("");
        }
    }

    private Widget doUpdate() {
        HorizontalPanel hp = new HorizontalPanel();
        final CheckBox cb = new CheckBox();
        cb.setValue(Boolean.valueOf(this.editingCol.isUpdate()));
        cb.setText("");
        cb.setEnabled(!this.isReadOnly);
        if (!this.isReadOnly) {
            cb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (ActionSetFieldPopup.this.sce.isGlobalVariable(ActionSetFieldPopup.this.editingCol.getBoundName())) {
                        cb.setEnabled(false);
                        ActionSetFieldPopup.this.editingCol.setUpdate(false);
                    } else {
                        ActionSetFieldPopup.this.editingCol.setUpdate(cb.getValue().booleanValue());
                    }
                }
            });
        }
        hp.add((Widget)cb);
        hp.add((Widget)new InfoPopup(Constants.INSTANCE.UpdateFact(), Constants.INSTANCE.UpdateDescription()));
        return hp;
    }

    private String getFactType() {
        if (this.sce.isGlobalVariable(this.editingCol.getBoundName())) {
            return this.sce.getGlobalVariable(this.editingCol.getBoundName());
        }
        return this.getFactType(this.editingCol.getBoundName());
    }

    private String getFactType(String boundName) {
        return this.rm.getLHSBoundFact(boundName).getFactType();
    }

    private TextBox getFieldLabel() {
        final TextBox box = new TextBox();
        box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ActionSetFieldPopup.this.editingCol.setFactField(box.getText());
            }
        });
        return box;
    }

    private ListBox loadBoundFacts(String binding) {
        ListBox listBox = new ListBox();
        listBox.addItem(Constants.INSTANCE.Choose());
        List factBindings = this.rm.getLHSBoundFacts();
        for (int index = 0; index < factBindings.size(); ++index) {
            String boundName = (String)factBindings.get(index);
            if ("".equals(boundName)) continue;
            listBox.addItem(boundName);
            if (!boundName.equals(binding)) continue;
            listBox.setSelectedIndex(index + 1);
        }
        String[] globs = this.sce.getGlobalVariables();
        for (int i = 0; i < globs.length; ++i) {
            listBox.addItem(globs[i]);
        }
        listBox.setEnabled(listBox.getItemCount() > 1);
        if (listBox.getItemCount() == 1) {
            listBox.clear();
            listBox.addItem(Constants.INSTANCE.NoPatternBindingsAvailable());
        }
        return listBox;
    }

    private boolean nil(String s) {
        return s == null || s.equals("");
    }

    private void showChangeFact(ClickEvent w) {
        final FormStylePopup pop = new FormStylePopup();
        final ListBox pats = this.loadBoundFacts(this.editingCol.getBoundName());
        pop.addAttribute(Constants.INSTANCE.ChooseFact(), (Widget)pats);
        Button ok = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String val = pats.getValue(pats.getSelectedIndex());
                ActionSetFieldPopup.this.editingCol.setBoundName(val);
                ActionSetFieldPopup.this.editingCol.setFactField(null);
                ActionSetFieldPopup.this.makeLimitedValueWidget();
                ActionSetFieldPopup.this.makeDefaultValueWidget();
                ActionSetFieldPopup.this.doBindingLabel();
                ActionSetFieldPopup.this.doFieldLabel();
                ActionSetFieldPopup.this.doValueList();
                pop.hide();
            }
        });
        pop.show();
    }

    private void showFieldChange() {
        final FormStylePopup pop = new FormStylePopup();
        pop.setModal(false);
        final String factType = this.getFactType();
        String[] fields = this.sce.getFieldCompletions(factType);
        final ListBox box = new ListBox();
        for (int i = 0; i < fields.length; ++i) {
            box.addItem(fields[i]);
        }
        pop.addAttribute(Constants.INSTANCE.Field(), (Widget)box);
        Button b = new Button(Constants.INSTANCE.OK());
        pop.addAttribute("", (Widget)b);
        b.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                ActionSetFieldPopup.this.editingCol.setFactField(box.getItemText(box.getSelectedIndex()));
                ActionSetFieldPopup.this.editingCol.setType(ActionSetFieldPopup.this.sce.getFieldType(factType, ActionSetFieldPopup.this.editingCol.getFactField()));
                ActionSetFieldPopup.this.makeLimitedValueWidget();
                ActionSetFieldPopup.this.makeDefaultValueWidget();
                ActionSetFieldPopup.this.doFieldLabel();
                ActionSetFieldPopup.this.doValueList();
                pop.hide();
            }
        });
        pop.show();
    }

    private boolean isValidFactType() {
        return this.editingCol.getBoundName() != null && !"".equals(this.editingCol.getBoundName());
    }

    private boolean isValidFactField() {
        return this.editingCol.getFactField() != null && !"".equals(this.editingCol.getFactField());
    }

    private boolean unique(String header) {
        for (ActionCol52 o : this.model.getActionCols()) {
            if (!o.getHeader().equals(header)) continue;
            return false;
        }
        return true;
    }
}

