/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.ConstraintEditor;
import org.drools.guvnor.client.asseteditor.drools.WorkingSetEditor;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.ide.common.client.factconstraints.ConstraintConfiguration;
import org.drools.ide.common.client.factconstraints.helper.ConstraintsContainer;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class FactsConstraintsEditorPanel
extends Composite {
    private static int idGenerator = 0;
    private ListBox factsCombo = new ListBox(false);
    private ListBox fieldsCombo = new ListBox(false);
    private ListBox constraintsCombo = new ListBox(false);
    private VerticalPanel vpConstraintConf = new VerticalPanel();
    private boolean validFactsChanged = true;
    private Map<String, ConstraintConfiguration> contraintsMap = new HashMap<String, ConstraintConfiguration>();
    private final Asset workingSet;
    private final WorkingSetEditor workingSetEditor;

    public FactsConstraintsEditorPanel(WorkingSetEditor workingSetEditor) {
        this.workingSetEditor = workingSetEditor;
        this.workingSet = workingSetEditor.getWorkingSet();
        this.factsCombo.setVisibleItemCount(1);
        this.fieldsCombo.setVisibleItemCount(1);
        this.constraintsCombo.setVisibleItemCount(5);
        this.factsCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FactsConstraintsEditorPanel.this.fillSelectedFactFields();
            }
        });
        this.fieldsCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FactsConstraintsEditorPanel.this.fillFieldConstrains();
            }
        });
        Image addNewConstraint = DroolsGuvnorImages.INSTANCE.NewItem();
        addNewConstraint.setAltText(Constants.INSTANCE.AddNewConstraint());
        addNewConstraint.setTitle(Constants.INSTANCE.AddNewConstraint());
        addNewConstraint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FactsConstraintsEditorPanel.this.showNewConstrainPop();
            }
        });
        Image removeConstraint = new Image(DroolsGuvnorImageResources.INSTANCE.trash());
        removeConstraint.setTitle(Constants.INSTANCE.removeConstraint());
        removeConstraint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FactsConstraintsEditorPanel.this.removeConstraint();
            }
        });
        FlexTable table = new FlexTable();
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(Constants.INSTANCE.FactTypes()));
        vp.add((Widget)this.factsCombo);
        table.setWidget(0, 0, (Widget)vp);
        vp = new VerticalPanel();
        vp.add((Widget)new SmallLabel(Constants.INSTANCE.Field()));
        vp.add((Widget)this.fieldsCombo);
        table.setWidget(1, 0, (Widget)vp);
        vp = new VerticalPanel();
        HorizontalPanel hp = new HorizontalPanel();
        vp.add((Widget)new SmallLabel(Constants.INSTANCE.Constraints()));
        hp.add((Widget)this.constraintsCombo);
        VerticalPanel btnPanel = new VerticalPanel();
        btnPanel.add((Widget)addNewConstraint);
        btnPanel.add((Widget)removeConstraint);
        hp.add((Widget)btnPanel);
        vp.add((Widget)hp);
        table.setWidget(2, 0, (Widget)vp);
        table.getFlexCellFormatter().setRowSpan(2, 0, 3);
        this.constraintsCombo.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FactsConstraintsEditorPanel.this.showConstraintConfig();
            }
        });
        this.vpConstraintConf.add((Widget)new SmallLabel(Constants.INSTANCE.ConstraintsParameters()));
        this.vpConstraintConf.add((Widget)new SmallLabel(""));
        table.setWidget(0, 1, (Widget)this.vpConstraintConf);
        table.getFlexCellFormatter().setRowSpan(0, 1, 5);
        this.fillSelectedFacts();
        this.fillSelectedFactFields();
        this.fillFieldConstrains();
        this.showConstraintConfig();
        this.initWidget((Widget)table);
    }

    protected final void fillSelectedFacts() {
        if (this.validFactsChanged) {
            String s = this.factsCombo.getSelectedIndex() != -1 ? this.factsCombo.getItemText(this.factsCombo.getSelectedIndex()) : "";
            this.factsCombo.clear();
            this.validFactsChanged = false;
            for (int i = 0; i < this.workingSetEditor.getValidFactsListBox().getItemCount(); ++i) {
                String itemText = this.workingSetEditor.getValidFactsListBox().getItemText(i);
                this.factsCombo.addItem(itemText);
                if (!s.equals(itemText)) continue;
                this.factsCombo.setSelectedIndex(i);
            }
            if (this.factsCombo.getSelectedIndex() == -1 && this.factsCombo.getItemCount() > 0) {
                this.factsCombo.setSelectedIndex(0);
            }
            this.fillSelectedFactFields();
        }
    }

    private void fillSelectedFactFields() {
        if (this.factsCombo.getSelectedIndex() != -1) {
            String fact = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.fieldsCombo.clear();
            for (String field : this.getCompletionEngine().getFieldCompletions(fact)) {
                this.fieldsCombo.addItem(field);
            }
        }
        if (this.fieldsCombo.getSelectedIndex() == -1 && this.fieldsCombo.getItemCount() > 0) {
            this.fieldsCombo.setSelectedIndex(0);
        }
        this.fillFieldConstrains();
    }

    private void fillFieldConstrains() {
        if (this.fieldsCombo.getSelectedIndex() != -1 && this.factsCombo.getSelectedIndex() != -1) {
            String fieldName = this.fieldsCombo.getItemText(this.fieldsCombo.getSelectedIndex());
            String factField = this.factsCombo.getItemText(this.factsCombo.getSelectedIndex());
            this.constraintsCombo.clear();
            this.contraintsMap.clear();
            for (ConstraintConfiguration c : this.workingSetEditor.getConstraintsConstrainer().getConstraints(factField, fieldName)) {
                this.constraintsCombo.addItem(c.getConstraintName(), this.addContrainsMap(c));
            }
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)new SmallLabel());
        }
        this.showConstraintConfig();
    }

    private synchronized String addContrainsMap(ConstraintConfiguration c) {
        String constraintId = String.valueOf(idGenerator++);
        this.contraintsMap.put(constraintId, c);
        return constraintId;
    }

    protected void removeConstraint() {
        if (this.constraintsCombo.getSelectedIndex() != -1) {
            ConstraintConfiguration c = this.contraintsMap.get(this.constraintsCombo.getValue(this.constraintsCombo.getSelectedIndex()));
            ((WorkingSetConfigData)this.workingSet.getContent()).constraints = this.workingSetEditor.getConstraintsConstrainer().removeConstraint(c);
        }
        this.fillFieldConstrains();
    }

    private void showConstraintConfig() {
        if (this.constraintsCombo.getItemCount() == 0) {
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)new SmallLabel());
            return;
        }
        if (this.constraintsCombo.getSelectedIndex() != -1) {
            ConstraintConfiguration c = this.contraintsMap.get(this.constraintsCombo.getValue(this.constraintsCombo.getSelectedIndex()));
            ConstraintEditor editor = new ConstraintEditor(c);
            this.vpConstraintConf.remove(this.vpConstraintConf.getWidgetCount() - 1);
            this.vpConstraintConf.add((Widget)editor);
        }
    }

    private void showNewConstrainPop() {
        Image image = new Image(DroolsGuvnorImageResources.INSTANCE.config());
        image.setAltText(Constants.INSTANCE.Config());
        final FormStylePopup pop = new FormStylePopup(image, Constants.INSTANCE.AddNewConstraint());
        Button addbutton = new Button(Constants.INSTANCE.OK());
        final ListBox consDefsCombo = new ListBox(false);
        consDefsCombo.setVisibleItemCount(5);
        addbutton.setTitle(Constants.INSTANCE.AddNewConstraint());
        ArrayList names = new ArrayList(ConstraintsContainer.getAllConfigurations().keySet());
        Collections.sort(names);
        for (String name : names) {
            consDefsCombo.addItem(name);
        }
        addbutton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String name = consDefsCombo.getItemText(consDefsCombo.getSelectedIndex());
                ConstraintConfiguration config = ConstraintsContainer.getEmptyConfiguration((String)name);
                if (config != null) {
                    String factName = FactsConstraintsEditorPanel.this.factsCombo.getItemText(FactsConstraintsEditorPanel.this.factsCombo.getSelectedIndex());
                    String fieldName = FactsConstraintsEditorPanel.this.fieldsCombo.getItemText(FactsConstraintsEditorPanel.this.fieldsCombo.getSelectedIndex());
                    config.setFactType(factName);
                    config.setFieldName(fieldName);
                    if (((WorkingSetConfigData)((FactsConstraintsEditorPanel)FactsConstraintsEditorPanel.this).workingSet.getContent()).constraints == null) {
                        ((WorkingSetConfigData)((FactsConstraintsEditorPanel)FactsConstraintsEditorPanel.this).workingSet.getContent()).constraints = new ArrayList<ConstraintConfiguration>();
                    }
                    ((WorkingSetConfigData)((FactsConstraintsEditorPanel)FactsConstraintsEditorPanel.this).workingSet.getContent()).constraints.add(config);
                    FactsConstraintsEditorPanel.this.constraintsCombo.addItem(config.getConstraintName(), FactsConstraintsEditorPanel.this.addContrainsMap(config));
                    FactsConstraintsEditorPanel.this.workingSetEditor.getConstraintsConstrainer().addConstraint(config);
                }
                pop.hide();
            }
        });
        pop.addAttribute(Constants.INSTANCE.WillExtendTheFollowingRuleCalled(), (Widget)consDefsCombo);
        pop.addAttribute("", (Widget)addbutton);
        pop.show();
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return SuggestionCompletionCache.getInstance().getEngineFromCache(this.workingSet.getMetaData().getModuleName());
    }

    public void notifyValidFactsChanged() {
        this.validFactsChanged = true;
    }
}

