/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.DSLRuleEditor;
import org.drools.guvnor.client.asseteditor.drools.ListUtil;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;

public class ChoiceList
extends PopupPanel {
    private ListBox list;
    private final DSLSentence[] sentences;
    private TextBox filter;

    public ChoiceList(DSLSentence[] sen, final DSLRuleEditor self) {
        super(true);
        this.setGlassEnabled(true);
        this.sentences = sen;
        this.filter = new TextBox();
        this.filter.setWidth("100%");
        final String defaultMessage = Constants.INSTANCE.enterTextToFilterList();
        this.filter.setText(defaultMessage);
        this.filter.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                ChoiceList.this.filter.setText("");
            }
        });
        this.filter.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                ChoiceList.this.filter.setText(defaultMessage);
            }
        });
        this.filter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    ChoiceList.this.applyChoice(self);
                } else {
                    ChoiceList.this.populateList(ListUtil.filter(ChoiceList.this.sentences, ChoiceList.this.filter.getText()));
                }
            }
        });
        this.filter.setFocus(true);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)this.filter);
        this.list = new ListBox();
        this.list.setVisibleItemCount(5);
        this.populateList(ListUtil.filter(this.sentences, ""));
        panel.add((Widget)this.list);
        Button ok = new Button(Constants.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChoiceList.this.applyChoice(self);
            }
        });
        Button cancel = new Button(Constants.INSTANCE.Cancel());
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChoiceList.this.hide();
            }
        });
        HorizontalPanel buttons = new HorizontalPanel();
        buttons.add((Widget)ok);
        buttons.add((Widget)cancel);
        panel.add((Widget)buttons);
        this.add((Widget)panel);
        this.setStyleName("ks-popups-Popup");
    }

    private void applyChoice(DSLRuleEditor self) {
        self.insertText(this.getSelectedItem());
        this.hide();
    }

    private void populateList(List<DSLSentence> filtered) {
        this.list.clear();
        for (int i = 0; i < filtered.size(); ++i) {
            this.list.addItem(filtered.get(i).getDefinition());
        }
    }

    public String getSelectedItem() {
        return this.list.getItemText(this.list.getSelectedIndex());
    }
}

