/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;

public class ModuleHistoryIterator
implements Iterator<ModuleItem> {
    private Node head;
    private VersionIterator versionIterator;
    private RulesRepository rulesRepository;

    public ModuleHistoryIterator(RulesRepository rulesRepository, Node head) {
        this.head = head;
        this.rulesRepository = rulesRepository;
        try {
            this.versionIterator = VersionableItem.getVersionManager(head).getVersionHistory(head.getPath()).getAllVersions();
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.versionIterator.hasNext();
    }

    @Override
    public ModuleItem next() {
        return new ModuleItem(this.rulesRepository, (Node)((Version)this.versionIterator.next()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(int i) {
        this.versionIterator.skip((long)i);
    }
}

