/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.workbench.models.commons.shared.imports.Import;
import org.drools.workbench.models.commons.shared.imports.Imports;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.TypeSource;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.api.builder.KieModule;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.scanner.KieModuleMetaData;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ProjectDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracle;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
@Named(value="ProjectDataModelOracleCache")
public class LRUProjectDataModelOracleCache
extends LRUCache<Project, ProjectDataModelOracle> {
    private static final String ERROR_CLASS_NOT_FOUND = "Class not found";
    private static final String ERROR_IO = "IO Error";
    @Inject
    private Paths paths;
    @Inject
    private POMService pomService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ProjectService projectService;
    @Inject
    private LRUBuilderCache cache;
    @Inject
    private Event<BuildResults> buildResultsEvent;

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        Project project = this.projectService.resolveProject(resourcePath);
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized ProjectDataModelOracle assertProjectDataModelOracle(Project project) {
        ProjectDataModelOracle projectOracle = (ProjectDataModelOracle)this.getEntry(project);
        if (projectOracle == null) {
            projectOracle = this.makeProjectOracle(project);
            this.setEntry(project, projectOracle);
        }
        return projectOracle;
    }

    private ProjectDataModelOracle makeProjectOracle(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)builder.getKieModuleIgnoringErrors());
        ProjectDataModelOracleBuilder pdBuilder = ProjectDataModelOracleBuilder.newProjectOracleBuilder();
        for (String packageName : metaData.getPackages()) {
            for (String className : metaData.getClasses(packageName)) {
                Class clazz = metaData.getClass(packageName, className);
                TypeMetaInfo typeMetaInfo = metaData.getTypeMetaInfo(clazz);
                TypeSource typeSource = builder.getClassSource(metaData, clazz);
                try {
                    pdBuilder.addClass(clazz, typeMetaInfo.isEvent(), typeSource);
                }
                catch (IOException ioe) {
                    results.addBuildMessage(this.makeMessage(ERROR_IO, ioe));
                }
            }
        }
        Path nioExternalImportsPath = this.paths.convert(project.getImportsPath());
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = this.paths.convert(nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(item.getType());
                    pdBuilder.addClass(clazz);
                }
                catch (ClassNotFoundException cnfe) {
                    results.addBuildMessage(this.makeMessage(ERROR_CLASS_NOT_FOUND, cnfe));
                }
                catch (IOException ioe) {
                    results.addBuildMessage(this.makeMessage(ERROR_IO, ioe));
                }
            }
        }
        if (!results.getMessages().isEmpty()) {
            this.buildResultsEvent.fire((Object)results);
        }
        return pdBuilder.build();
    }

    private BuildMessage makeMessage(String prefix, Exception e) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(prefix + ": " + e.getMessage());
        return buildMessage;
    }
}

