/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.backend.file.FileDiscoveryService;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.datamodel.backend.server.builder.packages.PackageDataModelOracleBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUProjectDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracle;
import org.uberfire.backend.server.util.Paths;

@ApplicationScoped
@Named(value="PackageDataModelOracleCache")
public class LRUDataModelOracleCache
extends LRUCache<Package, PackageDataModelOracle> {
    private static final DirectoryStream.Filter<Path> FILTER_ENUMERATIONS = new FileExtensionFilter(".enumeration");
    private static final DirectoryStream.Filter<Path> FILTER_DSLS = new FileExtensionFilter(".dsl");
    private static final DirectoryStream.Filter<Path> FILTER_GLOBALS = new FileExtensionFilter(".global.drl");
    @Inject
    private Paths paths;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private FileDiscoveryService fileDiscoveryService;
    @Inject
    @Named(value="ProjectDataModelOracleCache")
    private LRUProjectDataModelOracleCache cacheProjects;
    @Inject
    private ProjectService projectService;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;

    public synchronized void invalidatePackageCache(@Observes InvalidateDMOPackageCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        Package pkg = this.projectService.resolvePackage(resourcePath);
        if (pkg != null) {
            this.invalidateCache(pkg);
        }
    }

    public synchronized void invalidateProjectPackagesCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getResourcePath();
        Project project = this.projectService.resolveProject(resourcePath);
        if (project == null) {
            return;
        }
        String projectUri = project.getRootPath().toURI();
        ArrayList<Package> cacheEntriesToInvalidate = new ArrayList<Package>();
        for (Package pkg : this.getKeys()) {
            org.uberfire.backend.vfs.Path packageMainSrcPath = pkg.getPackageMainSrcPath();
            org.uberfire.backend.vfs.Path packageTestSrcPath = pkg.getPackageTestSrcPath();
            org.uberfire.backend.vfs.Path packageMainResourcesPath = pkg.getPackageMainResourcesPath();
            org.uberfire.backend.vfs.Path packageTestResourcesPath = pkg.getPackageTestResourcesPath();
            if (packageMainSrcPath != null && packageMainSrcPath.toURI().startsWith(projectUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageTestSrcPath != null && packageTestSrcPath.toURI().startsWith(projectUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageMainResourcesPath != null && packageMainResourcesPath.toURI().startsWith(projectUri)) {
                cacheEntriesToInvalidate.add(pkg);
                continue;
            }
            if (packageTestResourcesPath == null || !packageTestResourcesPath.toURI().startsWith(projectUri)) continue;
            cacheEntriesToInvalidate.add(pkg);
        }
        for (Package pkg : cacheEntriesToInvalidate) {
            this.invalidateCache(pkg);
        }
    }

    public synchronized PackageDataModelOracle assertPackageDataModelOracle(Project project, Package pkg) {
        PackageDataModelOracle oracle = (PackageDataModelOracle)this.getEntry(pkg);
        if (oracle == null) {
            oracle = this.makePackageDataModelOracle(project, pkg);
            this.setEntry(pkg, oracle);
        }
        return oracle;
    }

    private PackageDataModelOracle makePackageDataModelOracle(Project project, Package pkg) {
        String packageName = pkg.getPackageName();
        PackageDataModelOracleBuilder dmoBuilder = PackageDataModelOracleBuilder.newPackageOracleBuilder(packageName);
        ProjectDataModelOracle projectOracle = this.cacheProjects.assertProjectDataModelOracle(project);
        dmoBuilder.setProjectOracle(projectOracle);
        this.loadEnumsForPackage(dmoBuilder, pkg);
        this.loadDslsForPackage(dmoBuilder, pkg);
        this.loadGlobalsForPackage(dmoBuilder, pkg);
        if (!dmoBuilder.getErrors().isEmpty()) {
            IncrementalBuildResults results = new IncrementalBuildResults();
            List<String> errors = dmoBuilder.getErrors();
            for (String error : errors) {
                results.addAddedMessage(this.makeMessage(error));
            }
            this.incrementalBuildResultsEvent.fire((Object)results);
        }
        return dmoBuilder.build();
    }

    private BuildMessage makeMessage(String msg) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(msg);
        return buildMessage;
    }

    private void loadEnumsForPackage(PackageDataModelOracleBuilder dmoBuilder, Package pkg) {
        Path nioPackagePath = this.paths.convert(pkg.getPackageMainResourcesPath());
        Collection enumFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, FILTER_ENUMERATIONS);
        for (Path path : enumFiles) {
            String enumDefinition = this.ioService.readAllString(path);
            dmoBuilder.addEnum(enumDefinition);
        }
    }

    private void loadDslsForPackage(PackageDataModelOracleBuilder dmoBuilder, Package pkg) {
        Path nioPackagePath = this.paths.convert(pkg.getPackageMainResourcesPath());
        Collection dslFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, FILTER_DSLS);
        for (Path path : dslFiles) {
            String dslDefinition = this.ioService.readAllString(path);
            dmoBuilder.addDsl(dslDefinition);
        }
    }

    private void loadGlobalsForPackage(PackageDataModelOracleBuilder dmoBuilder, Package pkg) {
        Path nioPackagePath = this.paths.convert(pkg.getPackageMainResourcesPath());
        Collection globalFiles = this.fileDiscoveryService.discoverFiles(nioPackagePath, FILTER_GLOBALS);
        for (Path path : globalFiles) {
            String definition = this.ioService.readAllString(path);
            dmoBuilder.addGlobals(definition);
        }
    }
}

