/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.util;

import java.util.ArrayList;
import java.util.List;
import org.kie.commons.data.Pair;

public final class GlobalsParser {
    private static String KEYWORD = "global";

    private GlobalsParser() {
    }

    public static List<Pair<String, String>> parseGlobals(String content) {
        ArrayList<Pair<String, String>> globals = new ArrayList<Pair<String, String>>();
        if (content == null || content.isEmpty()) {
            return globals;
        }
        String[] lines = content.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            Pair<String, String> g = GlobalsParser.parseGlobal(line);
            if (g == null) continue;
            globals.add(g);
        }
        return globals;
    }

    private static Pair<String, String> parseGlobal(String line) {
        if (line.equals("") || line.startsWith("#")) {
            return null;
        }
        String compactedLine = line.replaceAll("^ +| +$|( )+", "$1");
        String[] fragments = compactedLine.split(" ");
        if (fragments.length != 3) {
            return null;
        }
        if (!fragments[0].equalsIgnoreCase(KEYWORD)) {
            return null;
        }
        String className = fragments[1];
        String alias = GlobalsParser.stripSemiColon(fragments[2]);
        Pair g = new Pair((Object)alias, (Object)className);
        return g;
    }

    private static String stripSemiColon(String className) {
        if (className.endsWith(";")) {
            return className.substring(0, className.indexOf(";"));
        }
        return className;
    }
}

