/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.projects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.common.services.project.builder.model.TypeSource;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ClassFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.FactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.SimpleFactBuilder;
import org.kie.workbench.common.services.datamodel.backend.server.builder.util.DataEnumLoader;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracleImpl;

public final class ProjectDataModelOracleBuilder {
    private ProjectDataModelOracleImpl oracle = new ProjectDataModelOracleImpl();
    private List<FactBuilder> factTypeBuilders = new ArrayList<FactBuilder>();
    private Map<String, String[]> factFieldEnums = new HashMap<String, String[]>();
    private List<String> errors = new ArrayList<String>();

    public static ProjectDataModelOracleBuilder newProjectOracleBuilder() {
        return new ProjectDataModelOracleBuilder();
    }

    private ProjectDataModelOracleBuilder() {
    }

    public SimpleFactBuilder addFact(String factType) {
        return this.addFact(factType, false);
    }

    public SimpleFactBuilder addFact(String factType, boolean isEvent) {
        return this.addFact(factType, isEvent, TypeSource.JAVA_PROJECT);
    }

    public SimpleFactBuilder addFact(String factType, boolean isEvent, TypeSource typeSource) {
        SimpleFactBuilder builder = new SimpleFactBuilder(this, factType, isEvent, typeSource);
        this.factTypeBuilders.add(builder);
        return builder;
    }

    public ProjectDataModelOracleBuilder addClass(Class clazz) throws IOException {
        return this.addClass(clazz, false);
    }

    public ProjectDataModelOracleBuilder addClass(Class clazz, boolean isEvent) throws IOException {
        return this.addClass(clazz, isEvent, TypeSource.JAVA_PROJECT);
    }

    public ProjectDataModelOracleBuilder addClass(Class clazz, boolean isEvent, TypeSource typeSource) throws IOException {
        ClassFactBuilder builder = new ClassFactBuilder(this, clazz, isEvent, typeSource);
        this.factTypeBuilders.add(builder);
        return this;
    }

    public ProjectDataModelOracleBuilder addEnum(String factType, String fieldName, String[] values) {
        String qualifiedFactField = factType + "#" + fieldName;
        this.factFieldEnums.put(qualifiedFactField, values);
        return this;
    }

    public ProjectDataModelOracleBuilder addEnum(String enumDefinition) {
        this.parseEnumDefinition(enumDefinition);
        return this;
    }

    private void parseEnumDefinition(String enumDefinition) {
        DataEnumLoader enumLoader = new DataEnumLoader(enumDefinition);
        if (enumLoader.hasErrors()) {
            this.logEnumErrors(enumLoader);
        } else {
            this.factFieldEnums.putAll(enumLoader.getData());
        }
    }

    private void logEnumErrors(DataEnumLoader enumLoader) {
        this.errors.addAll(enumLoader.getErrors());
    }

    public ProjectDataModelOracle build() {
        this.loadFactTypes();
        this.loadEnums();
        return this.oracle;
    }

    private void loadFactTypes() {
        for (FactBuilder factBuilder : this.factTypeBuilders) {
            factBuilder.build(this.oracle);
        }
    }

    private void loadEnums() {
        HashMap<String, String[]> loadableEnums = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> e : this.factFieldEnums.entrySet()) {
            String qualifiedFactField = e.getKey();
            loadableEnums.put(qualifiedFactField, e.getValue());
        }
        this.oracle.addEnumDefinitions(loadableEnums);
    }
}

