/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUProjectDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.oracle.PackageDataModelOracleImpl;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracle;
import org.kie.workbench.common.services.datamodel.oracle.ProjectDataModelOracleImpl;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class DataModelServiceImpl
implements DataModelService {
    @Inject
    @Named(value="PackageDataModelOracleCache")
    private LRUDataModelOracleCache cachePackages;
    @Inject
    @Named(value="ProjectDataModelOracleCache")
    private LRUProjectDataModelOracleCache cacheProjects;
    @Inject
    private ProjectService projectService;

    public PackageDataModelOracle getDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            Project project = this.resolveProject(resourcePath);
            Package pkg = this.resolvePackage(resourcePath);
            if (project == null) {
                return new PackageDataModelOracleImpl();
            }
            PackageDataModelOracle oracle = this.cachePackages.assertPackageDataModelOracle(project, pkg);
            return oracle;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ProjectDataModelOracle getProjectDataModel(Path resourcePath) {
        try {
            PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
            Project project = this.resolveProject(resourcePath);
            if (project == null) {
                return new ProjectDataModelOracleImpl();
            }
            ProjectDataModelOracle oracle = this.cacheProjects.assertProjectDataModelOracle(project);
            return oracle;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Project resolveProject(Path resourcePath) {
        return this.projectService.resolveProject(resourcePath);
    }

    private Package resolvePackage(Path resourcePath) {
        return this.projectService.resolvePackage(resourcePath);
    }
}

