/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class DateWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] DATE_TAG_OPEN = "<date>".getBytes();
    private static final byte[] DATE_TAG_CLOSE = "</date>".getBytes();
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";

    public DateWrapper(BeanManager beanManager) {
        super(beanManager);
    }

    private DateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    @Override
    public void marshal(OutputStream out) throws IOException {
        out.write(DATE_TAG_OPEN);
        if (Date.class.isAssignableFrom(this.value.getClass())) {
            out.write(this.getDateFormat().format(this.value).getBytes());
        } else if (Calendar.class.isAssignableFrom(this.value.getClass())) {
            out.write(this.getDateFormat().format(((Calendar)this.value).getTime()).getBytes());
        }
        out.write(DATE_TAG_CLOSE);
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        if (type instanceof Class && Date.class.isAssignableFrom((Class)type) || type.equals(Object.class)) {
            try {
                this.value = this.getDateFormat().parse(this.element.getStringValue());
            }
            catch (ParseException ex) {
                throw new ConversionException(String.format("Date value [%s] is not in a valid format.", this.element.getStringValue()));
            }
        } else if (type instanceof Class && Calendar.class.isAssignableFrom((Class)type)) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDateFormat().parse(this.element.getStringValue()));
                this.value = cal;
            }
            catch (ParseException ex) {
                throw new ConversionException(String.format("Date value [%s] is not in a valid format.", this.element.getStringValue()));
            }
        } else {
            throw new ConversionException(String.format("Value [%s] cannot be converted to type [%s].", this.element.getStringValue(), type));
        }
        return this.value;
    }

    @Override
    public ConversionScore conversionScore(Class<?> cls) {
        if (Date.class.isAssignableFrom(cls) || Calendar.class.isAssignableFrom(cls)) {
            return ConversionScore.exact;
        }
        if (cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

