/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class BooleanWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] BOOL_TAG_OPEN = "<bool>".getBytes();
    private static final byte[] BOOL_TAG_CLOSE = "</bool>".getBytes();

    public BooleanWrapper(BeanManager beanManager) {
        super(beanManager);
    }

    @Override
    public void marshal(OutputStream out) throws IOException {
        out.write(BOOL_TAG_OPEN);
        out.write(((Boolean)this.value).toString().getBytes());
        out.write(BOOL_TAG_CLOSE);
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        if (type.equals(Boolean.class) || type.equals(Object.class)) {
            this.value = Boolean.valueOf(this.element.getStringValue());
        } else if (type.equals(Boolean.TYPE)) {
            this.value = Boolean.parseBoolean(this.element.getStringValue());
        } else {
            throw new ConversionException(String.format("Parameter [%s] cannot be converted to type [%s].", this.element.getStringValue(), type));
        }
        return this.value;
    }

    @Override
    public ConversionScore conversionScore(Class<?> cls) {
        if (cls.equals(Boolean.class) || cls.equals(Boolean.TYPE)) {
            return ConversionScore.exact;
        }
        if (cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

