/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.dom4j.Element;
import org.jboss.seam.remoting.MetadataCache;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class BeanWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] REF_START_TAG_OPEN = "<ref id=\"".getBytes();
    private static final byte[] REF_START_TAG_END = "\"/>".getBytes();
    private static final byte[] BEAN_START_TAG_OPEN = "<bean type=\"".getBytes();
    private static final byte[] BEAN_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] BEAN_CLOSE_TAG = "</bean>".getBytes();
    private static final byte[] MEMBER_START_TAG_OPEN = "<member name=\"".getBytes();
    private static final byte[] MEMBER_START_TAG_CLOSE = "\">".getBytes();
    private static final byte[] MEMBER_CLOSE_TAG = "</member>".getBytes();
    private MetadataCache metadataCache;

    public BeanWrapper(BeanManager beanManager) {
        super(beanManager);
    }

    private MetadataCache getMetadataCache() {
        if (this.metadataCache == null) {
            Bean bean = (Bean)this.beanManager.getBeans(MetadataCache.class, new Annotation[0]).iterator().next();
            this.metadataCache = (MetadataCache)bean.create(this.beanManager.createCreationalContext((Contextual)bean));
        }
        return this.metadataCache;
    }

    @Override
    public void setElement(Element element) {
        super.setElement(element);
        String beanType = element.attributeValue("type");
        Set beans = this.beanManager.getBeans(beanType);
        if (beans.size() > 0) {
            Bean bean = (Bean)beans.iterator().next();
            this.value = bean.create(this.beanManager.createCreationalContext((Contextual)bean));
        } else {
            try {
                this.value = Class.forName(beanType).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not unmarshal bean element: " + element.getText(), ex);
            }
        }
    }

    public Type getBeanPropertyType(String propertyName) {
        Class<?> cls = this.value.getClass();
        String getter = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (Method m : cls.getMethods()) {
            if (!getter.equals(m.getName())) continue;
            return m.getGenericReturnType();
        }
        Field field = null;
        while (field == null && !cls.equals(Object.class)) {
            try {
                field = cls.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
        }
        if (field == null) {
            throw new IllegalArgumentException("Invalid property name [" + propertyName + "] specified for target class [" + this.value.getClass() + "]");
        }
        return field.getGenericType();
    }

    /*
     * Loose catch block
     */
    public Wrapper getBeanProperty(String propertyName) {
        Class<?> cls = this.value.getClass();
        Field f = null;
        try {
            f = cls.getField(propertyName);
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
        boolean accessible = false;
        if (f != null) {
            accessible = f.isAccessible();
            f.setAccessible(true);
            Wrapper wrapper = this.context.createWrapperFromObject(f.get(this.value), null);
            return wrapper;
        }
        Method accessor = null;
        try {
            accessor = cls.getMethod(String.format("get%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                accessor = cls.getMethod(String.format("is%s%s", Character.valueOf(Character.toUpperCase(propertyName.charAt(0))), propertyName.substring(1)), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                Wrapper wrapper = null;
                if (f != null) {
                    f.setAccessible(accessible);
                }
                return wrapper;
            }
        }
        Wrapper ex = this.context.createWrapperFromObject(accessor.invoke(this.value, new Object[0]), null);
        return ex;
        {
            catch (IllegalAccessException ex2) {
                throw new RuntimeException("Error reading value from field.");
            }
        }
        finally {
            if (f != null) {
                f.setAccessible(accessible);
            }
        }
    }

    public void setBeanProperty(String propertyName, Wrapper valueWrapper) {
        Class<?> cls = this.value.getClass();
        Method method = null;
        Field field = null;
        String setter = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        ConversionScore score = ConversionScore.nomatch;
        for (Method m : cls.getMethods()) {
            ConversionScore s;
            if (!setter.equals(m.getName()) || m.getParameterTypes().length != 1 || (s = valueWrapper.conversionScore(m.getParameterTypes()[0])).getScore() <= score.getScore()) continue;
            method = m;
            score = s;
        }
        if (method == null) {
            while (field == null && !cls.equals(Object.class)) {
                try {
                    field = cls.getDeclaredField(propertyName);
                }
                catch (NoSuchFieldException ex) {
                    cls = cls.getSuperclass();
                }
            }
            if (field == null) {
                throw new RuntimeException(String.format("Error while unmarshalling - property [%s] not found in class [%s]", propertyName, this.value.getClass().getName()));
            }
        }
        Object fieldValue = null;
        try {
            fieldValue = valueWrapper.convert(method != null ? method.getGenericParameterTypes()[0] : field.getGenericType());
        }
        catch (ConversionException ex) {
            throw new RuntimeException("Could not convert value while unmarshaling", ex);
        }
        if (method != null) {
            try {
                method.invoke(this.value, fieldValue);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not invoke setter method [%s]", method.getName()));
            }
        }
        boolean accessible = field.isAccessible();
        try {
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(this.value, fieldValue);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not set field value.", ex);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    @Override
    public void unmarshal() {
        List members = this.element.elements("member");
        for (Element member : members) {
            String name = member.attributeValue("name");
            Wrapper w = this.context.createWrapperFromElement((Element)member.elementIterator().next());
            this.setBeanProperty(name, w);
        }
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        if (type instanceof Class && ((Class)type).isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        throw new ConversionException(String.format("Value [%s] cannot be converted to type [%s].", this.value, type));
    }

    @Override
    public void marshal(OutputStream out) throws IOException {
        this.context.addOutRef(this);
        out.write(REF_START_TAG_OPEN);
        out.write(Integer.toString(this.context.getOutRefs().indexOf(this)).getBytes());
        out.write(REF_START_TAG_END);
    }

    @Override
    public void serialize(OutputStream out) throws IOException {
        this.serialize(out, null);
    }

    public void serialize(OutputStream out, List<String> constraints) throws IOException {
        Bean bean;
        out.write(BEAN_START_TAG_OPEN);
        Class<?> cls = this.value.getClass();
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if (cls.getName().contains("_$$_javassist_")) {
            cls = cls.getSuperclass();
        }
        if (cls.getName().contains("_$$_WeldClientProxy")) {
            cls = cls.getSuperclass();
        }
        String componentName = cls.getName();
        Set beans = this.beanManager.getBeans(cls, new Annotation[0]);
        if (beans.size() > 0 && (bean = (Bean)this.beanManager.getBeans(cls, new Annotation[0]).iterator().next()).getName() != null) {
            componentName = bean.getName();
        }
        out.write(componentName.getBytes());
        out.write(BEAN_START_TAG_CLOSE);
        for (String propertyName : this.getMetadataCache().getAccessibleProperties(cls).keySet()) {
            String fieldPath = this.path != null && this.path.length() > 0 ? String.format("%s.%s", this.path, propertyName) : propertyName;
            String wildCard = String.format("[%s].%s", componentName != null ? componentName : cls.getName(), propertyName);
            if (constraints != null && (constraints.contains(fieldPath) || constraints.contains(wildCard))) continue;
            out.write(MEMBER_START_TAG_OPEN);
            out.write(propertyName.getBytes());
            out.write(MEMBER_START_TAG_CLOSE);
            Wrapper w = this.getBeanProperty(propertyName);
            if (w != null) {
                w.setPath(fieldPath);
                w.marshal(out);
            }
            out.write(MEMBER_CLOSE_TAG);
        }
        out.write(BEAN_CLOSE_TAG);
    }

    @Override
    public ConversionScore conversionScore(Class<?> cls) {
        if (cls.equals(this.value.getClass())) {
            return ConversionScore.exact;
        }
        if (cls.isAssignableFrom(this.value.getClass()) || cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

