/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.Pattern;
import org.jboss.seam.remoting.validation.SpecialConsideration;

public class RegexpConsideration
implements SpecialConsideration {
    private static final Pattern BACKSLASH_REPLACEMENT = Pattern.compile("\\\\\\\\");
    private static final Pattern PERMANENT_START_REPLACEMENT = Pattern.compile("\\\\A");
    private static final Pattern PERMANENT_END_REPLACEMENT = Pattern.compile("\\\\Z");

    @Override
    public HashMap<String, Object> reassessParameters(Map<String, Object> constraintParams) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("regexp", RegexpConsideration.convertRegex((String)constraintParams.get("regexp")));
        Pattern.Flag[] flags = (Pattern.Flag[])constraintParams.get("flags");
        int[] values = new int[flags.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = flags[i].getValue();
        }
        ArrayList<String> changedFlags = RegexpConsideration.convertRegexFlags(values);
        if (changedFlags.size() > 0) {
            params.put("flags", changedFlags);
        }
        return params;
    }

    @Override
    public String reassessConstraintName(String constraintName) {
        return constraintName;
    }

    public static final String convertRegex(String regex) {
        regex = BACKSLASH_REPLACEMENT.matcher(regex).replaceAll("\\");
        regex = PERMANENT_START_REPLACEMENT.matcher(regex).replaceAll("^");
        if ((regex = PERMANENT_END_REPLACEMENT.matcher(regex).replaceAll("$")).charAt(0) != '^') {
            regex = "^" + regex;
        }
        if (regex.charAt(regex.length() - 1) != '$') {
            regex = regex + "$";
        }
        return regex;
    }

    public static final ArrayList<String> convertRegexFlags(int[] flags) {
        ArrayList<String> jsFlags = new ArrayList<String>();
        block4: for (int flag : flags) {
            switch (flag) {
                case 2: {
                    jsFlags.add("i");
                    continue block4;
                }
                case 8: {
                    jsFlags.add("m");
                }
            }
        }
        return jsFlags;
    }
}

