/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.util;

import java.util.Collection;
import java.util.Map;

public class JsConverter {
    public static final String convertArray(Object[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder content = new StringBuilder("[");
        for (Object temp : array) {
            content.append(JsConverter.convertObject(temp)).append(",");
        }
        content.deleteCharAt(content.length() - 1);
        content.append("]");
        return content.toString();
    }

    public static final String convertCollection(Collection<?> collection) {
        return JsConverter.convertArray(collection.toArray());
    }

    public static final String convertMap(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder content = new StringBuilder("{");
        for (Object key : map.keySet()) {
            content.append(key.toString()).append(" : ").append(JsConverter.convertObject(map.get(key))).append(",");
        }
        content.deleteCharAt(content.length() - 1);
        content.append("}");
        return content.toString();
    }

    public static final String convertObject(Object value) {
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Object[]) {
            return JsConverter.convertArray((Object[])value);
        }
        if (value instanceof Collection) {
            return JsConverter.convertCollection((Collection)value);
        }
        if (value instanceof Map) {
            return JsConverter.convertMap((Map)value);
        }
        return value.toString();
    }
}

