/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.remoting.AbstractRequestHandler;
import org.jboss.seam.remoting.Call;
import org.jboss.seam.remoting.MarshalUtils;
import org.jboss.seam.remoting.RequestContext;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.model.Model;
import org.jboss.seam.remoting.model.ModelRegistry;
import org.jboss.seam.remoting.wrapper.BagWrapper;
import org.jboss.seam.remoting.wrapper.BeanWrapper;
import org.jboss.seam.remoting.wrapper.MapWrapper;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.solder.logging.Logger;

public class ModelHandler
extends AbstractRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(ModelHandler.class);
    @Inject
    BeanManager beanManager;
    @Inject
    ModelRegistry registry;
    @Inject
    Conversation conversation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int read = request.getInputStream().read(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            read = request.getInputStream().read(buffer);
        }
        String requestData = new String(out.toByteArray());
        log.debug((Object)("Processing model request: " + requestData));
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read((Reader)new StringReader(requestData));
        Element env = doc.getRootElement();
        RequestContext ctx = new RequestContext(env.element("header"));
        try {
            this.activateConversationContext(request, ctx.getConversationId());
            Element modelElement = env.element("body").element("model");
            String operation = modelElement.attributeValue("operation");
            if ("expand".equals(operation)) {
                this.processExpandRequest(modelElement, ctx, (OutputStream)response.getOutputStream());
            } else {
                Model model = null;
                if ("fetch".equals(operation)) {
                    model = this.processFetchRequest(modelElement);
                } else if ("apply".equals(operation)) {
                    model = this.processApplyRequest(modelElement);
                }
                if (model.getAction() != null && model.getAction().getException() != null) {
                    response.getOutputStream().write(ENVELOPE_TAG_OPEN);
                    response.getOutputStream().write(BODY_TAG_OPEN);
                    MarshalUtils.marshalException(model.getAction().getException(), model.getAction().getContext(), (OutputStream)response.getOutputStream());
                    response.getOutputStream().write(BODY_TAG_CLOSE);
                    response.getOutputStream().write(ENVELOPE_TAG_CLOSE);
                    response.getOutputStream().flush();
                    return;
                }
                model.evaluate();
                ctx.setConversationId(this.conversation.isTransient() ? null : this.conversation.getId());
                this.marshalResponse(model, ctx, (OutputStream)response.getOutputStream());
            }
        }
        finally {
            this.deactivateConversationContext(request);
        }
    }

    private Model processFetchRequest(Element modelElement) throws Exception {
        Model model = this.registry.createModel();
        if (modelElement.elements("action").size() > 0) {
            this.unmarshalAction(modelElement.element("action"), model);
        }
        for (Element beanElement : modelElement.elements("bean")) {
            Element beanNameElement = beanElement.element("name");
            Element beanQualifierElement = beanElement.element("qualifier");
            Element beanPropertyElement = beanElement.element("property");
            model.addBean(beanElement.attributeValue("alias"), beanNameElement.getTextTrim(), beanQualifierElement != null ? beanQualifierElement.getTextTrim() : null, beanPropertyElement != null ? beanPropertyElement.getTextTrim() : null);
        }
        if (model.getAction() != null) {
            model.getAction().execute();
        }
        return model;
    }

    private void unmarshalAction(Element actionElement, Model model) {
        Element targetElement = actionElement.element("target");
        Element qualifiersElement = actionElement.element("qualifiers");
        Element methodElement = actionElement.element("method");
        Element paramsElement = actionElement.element("params");
        Element refsElement = actionElement.element("refs");
        model.setAction(new Call(this.beanManager, targetElement.getTextTrim(), qualifiersElement != null ? qualifiersElement.getTextTrim() : null, methodElement != null ? methodElement.getTextTrim() : null));
        if (refsElement != null) {
            for (Element refElement : refsElement.elements("ref")) {
                model.getAction().getContext().createWrapperFromElement(refElement);
            }
            for (Wrapper w : model.getAction().getContext().getInRefs().values()) {
                w.unmarshal();
            }
        }
        if (paramsElement != null) {
            for (Element paramElement : paramsElement.elements("param")) {
                model.getAction().addParameter(model.getAction().getContext().createWrapperFromElement((Element)paramElement.elements().get(0)));
            }
        }
    }

    private Model processApplyRequest(Element modelElement) throws Exception {
        Element delta;
        Model model = this.registry.getModel(modelElement.attributeValue("id"));
        model.setAction(null);
        for (int i = 0; i < model.getCallContext().getOutRefs().size(); ++i) {
            model.getCallContext().getInRefs().put("" + i, model.getCallContext().getOutRefs().get(i));
        }
        Element refsElement = modelElement.element("refs");
        if (refsElement != null) {
            ArrayList<Wrapper> newRefs = new ArrayList<Wrapper>();
            for (Element ref : refsElement.elements("ref")) {
                newRefs.add(model.getCallContext().createWrapperFromElement(ref));
            }
            for (Wrapper w : newRefs) {
                w.unmarshal();
            }
        }
        if ((delta = modelElement.element("delta")) != null) {
            List changesets = delta.elements("changeset");
            for (Element changeset : changesets) {
                Wrapper source;
                Wrapper target;
                int refId = Integer.parseInt(changeset.attributeValue("refid"));
                if (changeset.elements("member").size() > 0) {
                    target = model.getCallContext().getOutRefs().get(refId);
                    if (!(target instanceof BeanWrapper)) {
                        throw new IllegalStateException("Changeset for refId [" + refId + "] does not reference a valid bean object");
                    }
                    for (Element member : changeset.elements("member")) {
                        Type t;
                        String name = member.attributeValue("name");
                        Wrapper source2 = model.getCallContext().createWrapperFromElement((Element)member.elementIterator().next());
                        if (source2 instanceof BagWrapper) {
                            Wrapper targetBag = ((BeanWrapper)target).getBeanProperty(name);
                            if (targetBag == null) {
                                ((BeanWrapper)target).setBeanProperty(name, source2);
                                continue;
                            }
                            t = ((BeanWrapper)target).getBeanPropertyType(name);
                            if (this.cloneBagContents(source2.convert(t), targetBag.getValue())) continue;
                            ((BeanWrapper)target).setBeanProperty(name, source2);
                            continue;
                        }
                        if (source2 instanceof MapWrapper) {
                            Wrapper targetMap = ((BeanWrapper)target).getBeanProperty(name);
                            if (!Map.class.isAssignableFrom(targetMap.getClass())) {
                                throw new IllegalStateException("Cannot assign Map value to non Map property [" + target.getClass().getName() + "." + name + "]");
                            }
                            if (targetMap == null) {
                                ((BeanWrapper)target).setBeanProperty(name, source2);
                                continue;
                            }
                            t = ((BeanWrapper)target).getBeanPropertyType(name);
                            this.cloneMapContents((Map)source2.convert(t), (Map)((Object)targetMap));
                            continue;
                        }
                        ((BeanWrapper)target).setBeanProperty(name, source2);
                    }
                }
                if (changeset.elements("bag").size() > 0) {
                    target = model.getCallContext().getOutRefs().get(refId);
                    source = model.getCallContext().createWrapperFromElement(changeset.element("bag"));
                    this.cloneBagContents(source.convert(target.getValue().getClass()), target.getValue());
                    continue;
                }
                if (changeset.elements("map").size() <= 0) continue;
                target = model.getCallContext().getOutRefs().get(refId);
                source = model.getCallContext().createWrapperFromElement(changeset.element("map"));
                this.cloneMapContents((Map)source.convert(target.getValue().getClass()), (Map)target.getValue());
            }
        }
        if (modelElement.elements("action").size() > 0) {
            this.unmarshalAction(modelElement.element("action"), model);
        }
        if (model.getAction() != null) {
            model.getAction().execute();
        }
        return model;
    }

    private void processExpandRequest(Element modelElement, RequestContext ctx, OutputStream out) throws Exception {
        Model model = this.registry.getModel(modelElement.attributeValue("id"));
        model.setAction(null);
        Element refElement = modelElement.element("ref");
        if (refElement == null) {
            throw new IllegalStateException("Invalid request state - no object ref found");
        }
        int refId = Integer.parseInt(refElement.attributeValue("id"));
        Wrapper target = model.getCallContext().getOutRefs().get(refId);
        int newRefIdx = model.getCallContext().getOutRefs().size();
        Element memberElement = refElement.element("member");
        String memberName = memberElement.attributeValue("name");
        Wrapper value = ((BeanWrapper)target).getBeanProperty(memberName);
        if (value instanceof BagWrapper) {
            ((BagWrapper)value).setLoadLazy(true);
        }
        out.write(ENVELOPE_TAG_OPEN);
        out.write(HEADER_OPEN);
        out.write(CONTEXT_TAG_OPEN);
        if (ctx.getConversationId() != null) {
            out.write(CONVERSATION_ID_TAG_OPEN);
            out.write(ctx.getConversationId().getBytes());
            out.write(CONVERSATION_ID_TAG_CLOSE);
        }
        out.write(CALL_ID_TAG_OPEN);
        out.write(ctx.getCallId().toString().getBytes());
        out.write(CALL_ID_TAG_CLOSE);
        out.write(CONTEXT_TAG_CLOSE);
        out.write(HEADER_CLOSE);
        out.write(BODY_TAG_OPEN);
        MarshalUtils.marshalModelExpand(model, value, out, newRefIdx);
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }

    private boolean cloneBagContents(Object sourceBag, Object targetBag) {
        Class<?> cls = sourceBag.getClass();
        if (cls.isArray()) {
            int sourceLen = Array.getLength(sourceBag);
            int targetLen = Array.getLength(targetBag);
            if (targetLen != sourceLen) {
                return false;
            }
            for (int i = 0; i < sourceLen; ++i) {
                Array.set(targetBag, i, Array.get(sourceBag, i));
            }
            return true;
        }
        if (List.class.isAssignableFrom(cls)) {
            List sourceList = (List)sourceBag;
            List targetList = (List)targetBag;
            targetList.clear();
            for (int i = 0; i < sourceList.size(); ++i) {
                if (targetList.size() < i + 1) {
                    targetList.add(i, sourceList.get(i));
                    continue;
                }
                if (targetList.get(i) == sourceList.get(i)) continue;
                targetList.set(i, sourceList.get(i));
            }
            return true;
        }
        if (Set.class.isAssignableFrom(cls)) {
            Set sourceSet = (Set)sourceBag;
            Set targetSet = (Set)targetBag;
            for (Object e : sourceSet) {
                if (targetSet.contains(e)) continue;
                targetSet.add(e);
            }
            for (Object e : targetSet) {
                if (sourceSet.contains(e)) continue;
                targetSet.remove(e);
            }
            return true;
        }
        return false;
    }

    private void cloneMapContents(Map<Object, Object> sourceMap, Map<Object, Object> targetMap) {
        for (Object key : sourceMap.keySet()) {
            if (targetMap.containsKey(key)) continue;
            targetMap.put(key, sourceMap.get(key));
        }
        for (Object key : targetMap.keySet()) {
            if (sourceMap.containsKey(key)) continue;
            targetMap.remove(key);
        }
    }

    private void marshalResponse(Model model, RequestContext ctx, OutputStream out) throws IOException {
        out.write(ENVELOPE_TAG_OPEN);
        out.write(HEADER_OPEN);
        out.write(CONTEXT_TAG_OPEN);
        if (ctx.getConversationId() != null) {
            out.write(CONVERSATION_ID_TAG_OPEN);
            out.write(ctx.getConversationId().getBytes());
            out.write(CONVERSATION_ID_TAG_CLOSE);
        }
        out.write(CALL_ID_TAG_OPEN);
        out.write(ctx.getCallId().toString().getBytes());
        out.write(CALL_ID_TAG_CLOSE);
        out.write(CONTEXT_TAG_CLOSE);
        out.write(HEADER_CLOSE);
        out.write(BODY_TAG_OPEN);
        MarshalUtils.marshalModel(model, out);
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }
}

