/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.model;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.remoting.AnnotationsParser;
import org.jboss.seam.remoting.Call;
import org.jboss.seam.remoting.CallContext;
import org.jboss.seam.remoting.util.Strings;

public class Model
implements Serializable {
    private static final long serialVersionUID = 8318288750036758325L;
    private BeanManager beanManager;
    private String id;
    private CallContext callContext;
    private Call action;
    private Map<String, BeanProperty> beanProperties;

    public Model(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.id = UUID.randomUUID().toString();
        this.callContext = new CallContext(beanManager);
        this.beanProperties = new HashMap<String, BeanProperty>();
    }

    public void evaluate() {
        for (String alias : this.beanProperties.keySet()) {
            BeanProperty property = this.beanProperties.get(alias);
            property.evaluate(this.beanManager.createCreationalContext(property.getBean()));
        }
    }

    public Map<String, BeanProperty> getBeanProperties() {
        return this.beanProperties;
    }

    public String getId() {
        return this.id;
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    public void addBean(String alias, String beanName, String qualifiers, String propertyName) {
        Set beans = this.beanManager.getBeans(beanName);
        if (beans.isEmpty()) {
            try {
                Class<?> beanType = Class.forName(beanName);
                Annotation[] q = qualifiers != null && !Strings.isEmpty(qualifiers) ? new AnnotationsParser(beanType, qualifiers, this.beanManager).getAnnotations() : Call.EMPTY_ANNOTATIONS;
                beans = this.beanManager.getBeans(beanType, q);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid bean class specified: " + beanName);
            }
            if (beans.isEmpty()) {
                throw new IllegalArgumentException("Could not find bean with bean with type/name " + beanName + ", qualifiers [" + qualifiers + "]");
            }
        }
        Bean bean = (Bean)beans.iterator().next();
        this.beanProperties.put(alias, new BeanProperty(bean, propertyName));
    }

    public void setAction(Call action) {
        this.action = action;
    }

    public Call getAction() {
        return this.action;
    }

    public class BeanProperty
    implements Serializable {
        private static final long serialVersionUID = 540993772239615536L;
        private Bean<?> bean;
        private String propertyName;
        private Object value;

        public BeanProperty(Bean<?> bean, String propertyName) {
            this.bean = bean;
            this.propertyName = propertyName;
        }

        public Bean<?> getBean() {
            return this.bean;
        }

        public void evaluate(CreationalContext<?> ctx) {
            block10: {
                Object instance = Model.this.beanManager.getReference(this.bean, (Type)this.bean.getBeanClass(), ctx);
                if (this.propertyName != null) {
                    try {
                        Field f = this.bean.getBeanClass().getField(this.propertyName);
                        boolean accessible = f.isAccessible();
                        try {
                            f.setAccessible(true);
                            this.value = f.get(instance);
                            break block10;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception reading model property " + this.propertyName + " from bean [" + this.bean + "]");
                        }
                        finally {
                            f.setAccessible(accessible);
                        }
                    }
                    catch (NoSuchFieldException ex) {
                        String methodName = "get" + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
                        try {
                            Method m = this.bean.getBeanClass().getMethod(methodName, new Class[0]);
                            this.value = m.invoke(instance, new Object[0]);
                            break block10;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception reading model property " + this.propertyName + " from bean [" + this.bean + "]");
                        }
                    }
                }
                this.value = instance;
            }
        }

        public Object getValue() {
            return this.value;
        }
    }
}

