/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.remoting.ExecutionHandler;
import org.jboss.seam.remoting.InterfaceGenerator;
import org.jboss.seam.remoting.model.ModelHandler;
import org.jboss.seam.remoting.validation.ConstraintTranslator;
import org.jboss.solder.logging.Logger;

public class Remoting
extends HttpServlet {
    private static final long serialVersionUID = -3911197516105313424L;
    private static final String REQUEST_PATH_EXECUTE = "/execute";
    private static final String REQUEST_PATH_INTERFACE = "/interface.js";
    private static final String REQUEST_PATH_MODEL = "/model";
    private static final String REQUEST_PATH_VALIDATION = "/validate";
    @Inject
    Instance<ExecutionHandler> executionHandlerInstance;
    @Inject
    Instance<InterfaceGenerator> interfaceHandlerInstance;
    @Inject
    Instance<ModelHandler> modelHandlerInstance;
    @Inject
    Instance<ConstraintTranslator> translatorInstance;
    public static final int DEFAULT_POLL_TIMEOUT = 10;
    public static final int DEFAULT_POLL_INTERVAL = 1;
    private ServletConfig servletConfig;
    private int pollTimeout = 10;
    private int pollInterval = 1;
    private boolean debug = false;
    private Map<String, byte[]> cachedConfig = new HashMap<String, byte[]>();
    private Map<String, byte[]> resourceCache = new HashMap<String, byte[]>();
    private static final Logger log = Logger.getLogger(Remoting.class);
    private static final Pattern pathPattern = Pattern.compile("/(.*?)/([^/]+)");
    private static final String REMOTING_RESOURCE_PATH = "resource";

    private synchronized void initConfig(String contextPath, HttpServletRequest request) {
        if (!this.cachedConfig.containsKey(contextPath)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nSeam.resourcePath = \"");
            sb.append(contextPath);
            sb.append(request.getServletPath());
            sb.append(this.servletConfig.getServletContext().getContextPath());
            sb.append("\";");
            sb.append("\nSeam.debug = ");
            sb.append(this.getDebug() ? "true" : "false");
            sb.append(";");
            this.cachedConfig.put(contextPath, sb.toString().getBytes());
        }
    }

    private void appendConfig(OutputStream out, String contextPath, HttpServletRequest request) throws IOException {
        if (!this.cachedConfig.containsKey(contextPath)) {
            this.initConfig(contextPath, request);
        }
        out.write(this.cachedConfig.get(contextPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResource(String resourceName, HttpServletResponse response, boolean compress) throws IOException {
        String cacheKey = resourceName + ":" + Boolean.toString(compress);
        if (!this.resourceCache.containsKey(cacheKey)) {
            Map<String, byte[]> map = this.resourceCache;
            synchronized (map) {
                if (!this.resourceCache.containsKey(cacheKey)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    if (resourceName.endsWith(".js")) {
                        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/jboss/seam/remoting/" + resourceName);
                        try {
                            if (in != null) {
                                response.setContentType("text/javascript");
                                byte[] buffer = new byte[1024];
                                int read = in.read(buffer);
                                while (read != -1) {
                                    out.write(buffer, 0, read);
                                    read = in.read(buffer);
                                }
                                this.resourceCache.put(cacheKey, compress ? this.compressResource(out.toByteArray()) : out.toByteArray());
                                response.getOutputStream().write(this.resourceCache.get(cacheKey));
                            } else {
                                log.error((Object)String.format("Resource [%s] not found.", resourceName));
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                }
            }
        }
        response.getOutputStream().write(this.resourceCache.get(cacheKey));
    }

    private byte[] compressResource(byte[] resourceData) {
        String resource = new String(resourceData);
        resource = resource.replaceAll("/{2,}[^\\n\\r]*[\\n\\r]", "");
        resource = resource.replaceAll("/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*/", "");
        resource = resource.replaceAll(";\\s*[\\n\\r]+\\s*", ";");
        resource = resource.replaceAll("}\\s*[\\n\\r]+\\s*", "}");
        resource = resource.replaceAll("\\s*[\\n\\r]+\\s*", " ");
        return resource.getBytes();
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public void setPollTimeout(int pollTimeout) {
        this.pollTimeout = pollTimeout;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void destroy() {
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return null;
    }

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
    }

    protected ExecutionHandler getExecutionHandler() {
        return (ExecutionHandler)this.executionHandlerInstance.get();
    }

    protected InterfaceGenerator getInterfaceHandler() {
        return (InterfaceGenerator)this.interfaceHandlerInstance.get();
    }

    protected ModelHandler getModelHandler() {
        return (ModelHandler)this.modelHandlerInstance.get();
    }

    protected ConstraintTranslator getTranslatorHandler() {
        return (ConstraintTranslator)this.translatorInstance.get();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                response.sendError(404, "No path information provided");
                return;
            }
            if (pathInfo.startsWith(this.servletConfig.getServletContext().getContextPath())) {
                pathInfo = pathInfo.substring(this.servletConfig.getServletContext().getContextPath().length());
            }
            if (REQUEST_PATH_EXECUTE.equals(pathInfo)) {
                this.getExecutionHandler().handle(request, response);
            } else if (REQUEST_PATH_INTERFACE.equals(pathInfo)) {
                this.getInterfaceHandler().handle(request, response);
            } else if (REQUEST_PATH_MODEL.equals(pathInfo)) {
                this.getModelHandler().handle(request, response);
            } else if (REQUEST_PATH_VALIDATION.equals(pathInfo)) {
                this.getTranslatorHandler().handle(request, response);
            } else {
                Matcher m = pathPattern.matcher(pathInfo);
                if (m.matches()) {
                    String path = m.group(1);
                    String resource = m.group(2);
                    if (REMOTING_RESOURCE_PATH.equals(path)) {
                        String compressParam = request.getParameter("compress");
                        boolean compress = compressParam == null || !"false".equals(compressParam);
                        this.writeResource(resource, response, compress);
                        if ("remote.js".equals(resource)) {
                            this.appendConfig((OutputStream)response.getOutputStream(), request.getContextPath(), request);
                        }
                    }
                    response.getOutputStream().flush();
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error", (Throwable)ex);
        }
    }
}

