/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.seam.remoting.BeanMetadata;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.solder.logging.Logger;

@ApplicationScoped
public class MetadataCache {
    private static final Logger log = Logger.getLogger(MetadataCache.class);
    private Map<Class<?>, BeanMetadata> metadataCache;
    private Map<Class<?>, Set<Class<?>>> beanDependencies;
    private Map<Class<?>, Map<String, Type>> accessibleProperties = new HashMap();
    @Inject
    BeanManager beanManager;

    public MetadataCache() {
        this.metadataCache = new HashMap();
        this.beanDependencies = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanMetadata getMetadata(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("beanClass cannot be null");
        }
        if (this.metadataCache.containsKey(beanClass)) {
            return this.metadataCache.get(beanClass);
        }
        Map<Class<?>, BeanMetadata> map = this.metadataCache;
        synchronized (map) {
            if (!this.metadataCache.containsKey(beanClass)) {
                this.metadataCache.put(beanClass, this.generateBeanMetadata(beanClass));
                Set<Class<?>> dependencies = this.beanDependencies.get(beanClass);
                if (dependencies != null) {
                    for (Class<?> dependency : dependencies) {
                        this.getMetadata(dependency);
                    }
                }
            }
        }
        return this.metadataCache.get(beanClass);
    }

    @WebRemote
    public Set<BeanMetadata> loadBeans(Set<String> names) {
        HashSet<BeanMetadata> meta = new HashSet<BeanMetadata>();
        for (String name : names) {
            Class beanClass = null;
            Set beans = this.beanManager.getBeans(name);
            if (!beans.isEmpty()) {
                beanClass = ((Bean)beans.iterator().next()).getBeanClass();
            } else {
                try {
                    beanClass = Class.forName(name);
                }
                catch (ClassNotFoundException ex) {
                    log.error((Object)String.format("Component not found: [%s]", name));
                    throw new IllegalArgumentException(String.format("Component not found: [%s]", name));
                }
            }
            this.addBeanDependencies(beanClass, meta);
        }
        return meta;
    }

    private void addBeanDependencies(Class<?> beanClass, Set<BeanMetadata> types) {
        BeanMetadata meta = this.getMetadata(beanClass);
        if (types.contains(meta)) {
            return;
        }
        types.add(meta);
        Set<Class<?>> dependencies = this.getDependencies(beanClass);
        if (dependencies != null) {
            for (Class<?> dependencyClass : dependencies) {
                if (types.contains(dependencyClass)) continue;
                this.addBeanDependencies(dependencyClass, types);
            }
        }
    }

    private BeanMetadata generateBeanMetadata(Class<?> beanClass) {
        BeanMetadata.BeanType beanType = BeanMetadata.BeanType.state;
        String name = beanClass.getName();
        for (Method m : beanClass.getDeclaredMethods()) {
            if (m.getAnnotation(WebRemote.class) == null) continue;
            beanType = BeanMetadata.BeanType.action;
            String beanName = ((Bean)this.beanManager.getBeans(beanClass, new Annotation[0]).iterator().next()).getName();
            if (beanName == null) break;
            name = beanName;
            break;
        }
        BeanMetadata meta = new BeanMetadata(beanType, name);
        if (beanType == BeanMetadata.BeanType.state) {
            this.populateMetadataProperties(beanClass, meta);
        } else {
            this.populateMetadataMethods(beanClass, meta);
        }
        return meta;
    }

    private void populateMetadataProperties(Class<?> beanClass, BeanMetadata meta) {
        Map<String, Type> props = this.getAccessibleProperties(beanClass);
        for (String propertyName : props.keySet()) {
            Type propertyType = props.get(propertyName);
            meta.addProperty(propertyName, this.getFieldType(propertyType));
            this.addTypeDependency(beanClass, propertyType);
        }
    }

    private void populateMetadataMethods(Class<?> beanClass, BeanMetadata meta) {
        for (Method m : beanClass.getDeclaredMethods()) {
            if (m.getAnnotation(WebRemote.class) == null) continue;
            meta.addMethod(m.getName(), m.getParameterTypes().length);
            this.addTypeDependency(beanClass, m.getGenericReturnType());
            for (int i = 0; i < m.getGenericParameterTypes().length; ++i) {
                this.addTypeDependency(beanClass, m.getGenericParameterTypes()[i]);
            }
        }
    }

    private void addTypeDependency(Class<?> beanType, Type dependency) {
        Set<Class<?>> dependencies;
        if (!this.beanDependencies.containsKey(beanType)) {
            this.beanDependencies.put(beanType, new HashSet());
        }
        if ((dependencies = this.beanDependencies.get(beanType)).contains(dependency)) {
            return;
        }
        if (dependency instanceof Class) {
            Class classType = (Class)dependency;
            if (classType.isArray()) {
                this.addTypeDependency(beanType, classType.getComponentType());
                return;
            }
            if (classType.getName().startsWith("java.") || classType.isPrimitive() || classType.isEnum()) {
                return;
            }
            dependencies.add(classType);
        } else if (dependency instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)dependency).getActualTypeArguments()) {
                this.addTypeDependency(beanType, t);
            }
        }
    }

    public Set<Class<?>> getDependencies(Class<?> beanType) {
        return this.beanDependencies.get(beanType);
    }

    protected String getFieldType(Type type) {
        if (type.equals(String.class) || type instanceof Class && ((Class)type).isEnum() || type.equals(BigInteger.class) || type.equals(BigDecimal.class)) {
            return "str";
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return "number";
        }
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (Date.class.isAssignableFrom(cls) || Calendar.class.isAssignableFrom(cls)) {
                return "date";
            }
            if (cls.isArray()) {
                return "bag";
            }
            if (cls.isAssignableFrom(Map.class)) {
                return "map";
            }
            if (cls.isAssignableFrom(Collection.class)) {
                return "bag";
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (pt.getRawType() instanceof Class && Map.class.isAssignableFrom((Class)pt.getRawType())) {
                return "map";
            }
            if (pt.getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)pt.getRawType())) {
                return "bag";
            }
        }
        return "bean";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Type> getAccessibleProperties(Class<?> cls) {
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if (!this.accessibleProperties.containsKey(cls)) {
            Map<Class<?>, Map<String, Type>> map = this.accessibleProperties;
            synchronized (map) {
                if (!this.accessibleProperties.containsKey(cls)) {
                    HashMap<String, Type> properties = new HashMap<String, Type>();
                    for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
                        for (Field field : c.getDeclaredFields()) {
                            if (properties.containsKey(field.getName()) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                            if (Modifier.isPublic(field.getModifiers())) {
                                properties.put(field.getName(), field.getGenericType());
                                continue;
                            }
                            String fieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                            String getterName = String.format("get%s", fieldName);
                            Method getMethod = null;
                            try {
                                getMethod = c.getMethod(getterName, new Class[0]);
                            }
                            catch (SecurityException ex) {
                            }
                            catch (NoSuchMethodException ex) {
                                getterName = String.format("is%s", fieldName);
                                try {
                                    getMethod = c.getMethod(getterName, new Class[0]);
                                }
                                catch (NoSuchMethodException ex2) {
                                    // empty catch block
                                }
                            }
                            if (getMethod != null && Modifier.isPublic(getMethod.getModifiers())) {
                                properties.put(field.getName(), getMethod.getGenericReturnType());
                                continue;
                            }
                            String setterName = String.format("set%s", fieldName);
                            Method setMethod = null;
                            try {
                                setMethod = c.getMethod(setterName, field.getType());
                            }
                            catch (SecurityException ex) {
                            }
                            catch (NoSuchMethodException ex) {
                                // empty catch block
                            }
                            if (setMethod == null || !Modifier.isPublic(setMethod.getModifiers())) continue;
                            properties.put(field.getName(), setMethod.getGenericParameterTypes()[0]);
                        }
                        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                            if (!((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is")) continue;
                            int startIdx = ((Method)accessibleObject).getName().startsWith("get") ? 3 : 2;
                            try {
                                c.getMethod(String.format("set%s", ((Method)accessibleObject).getName().substring(startIdx)), ((Method)accessibleObject).getReturnType());
                            }
                            catch (NoSuchMethodException ex) {
                                continue;
                            }
                            String propertyName = String.format("%s%s", Character.valueOf(Character.toLowerCase(((Method)accessibleObject).getName().charAt(startIdx))), ((Method)accessibleObject).getName().substring(startIdx + 1));
                            if (properties.containsKey(propertyName)) continue;
                            properties.put(propertyName, ((Method)accessibleObject).getGenericReturnType());
                        }
                    }
                    this.accessibleProperties.put(cls, properties);
                }
            }
        }
        return this.accessibleProperties.get(cls);
    }
}

