/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.Messages;
import org.jboss.seam.remoting.WriteHeaderEvent;
import org.jboss.solder.core.Requires;

@ApplicationScoped
@Requires(value={"org.jboss.seam.international.status.Messages"})
public class MessageMarshaller {
    private static final byte[] MESSAGES_TAG_OPEN = "<msgs>".getBytes();
    private static final byte[] MESSAGES_TAG_CLOSE = "</msgs>".getBytes();
    private static final byte[] MESSAGE_TAG_OPEN = "<m".getBytes();
    private static final byte[] ATTRIB_LEVEL = " lvl=\"".getBytes();
    private static final byte[] ATTRIB_TARGETS = " tgt=\"".getBytes();
    private static final byte TAG_CLOSE = 62;
    private static final byte[] MESSAGE_TAG_CLOSE = "</m>".getBytes();
    private static final byte DOUBLE_QUOTE = 34;

    public static void marshalMessages(@Observes WriteHeaderEvent event, Messages msgs) throws IOException {
        Set messages = msgs.getAll();
        if (!messages.isEmpty()) {
            OutputStream out = event.getOutputStream();
            out.write(MESSAGES_TAG_OPEN);
            for (Message m : messages) {
                out.write(MESSAGE_TAG_OPEN);
                out.write(ATTRIB_LEVEL);
                out.write(m.getLevel().name().getBytes());
                out.write(34);
                if (m.getTargets() != null) {
                    out.write(ATTRIB_TARGETS);
                    out.write(m.getTargets().getBytes());
                    out.write(34);
                }
                out.write(62);
                out.write(URLEncoder.encode(m.getText(), "UTF-8").replace("+", "%20").getBytes());
                out.write(MESSAGE_TAG_CLOSE);
            }
            out.write(MESSAGES_TAG_CLOSE);
        }
    }
}

