/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.remoting.BeanMetadata;
import org.jboss.seam.remoting.MetadataCache;
import org.jboss.seam.remoting.RequestHandler;

public class InterfaceGenerator
implements RequestHandler {
    @Inject
    MetadataCache metadataCache;

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getQueryString() == null) {
            response.sendError(400, "Invalid request - no component specified");
        }
        response.setContentType("text/javascript");
        HashSet<String> names = new HashSet<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            names.add(((String)e.nextElement()).trim());
        }
        this.appendBeanSource((OutputStream)response.getOutputStream(), this.metadataCache.loadBeans(names));
    }

    private void appendBeanSource(OutputStream out, Set<BeanMetadata> types) throws IOException {
        StringBuilder src = new StringBuilder();
        for (BeanMetadata meta : types) {
            boolean first;
            if (meta.getBeanType() == BeanMetadata.BeanType.action) {
                src.append("Seam.registerBean(\"");
                src.append(meta.getName());
                src.append("\", null, {");
                first = true;
                for (String methodName : meta.getMethods().keySet()) {
                    if (!first) {
                        src.append(", ");
                    } else {
                        first = false;
                    }
                    src.append(methodName);
                    src.append(": ");
                    src.append(meta.getMethods().get(methodName));
                }
                src.append("});\n");
                continue;
            }
            src.append("Seam.registerBean(\"");
            src.append(meta.getName());
            src.append("\", {");
            first = true;
            for (String propertyName : meta.getProperties().keySet()) {
                if (!first) {
                    src.append(", ");
                } else {
                    first = false;
                }
                src.append(propertyName);
                src.append(": \"");
                src.append(meta.getProperties().get(propertyName));
                src.append("\"");
            }
            src.append("});\n");
        }
        out.write(src.toString().getBytes());
    }
}

