/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Conversation;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.remoting.AbstractRequestHandler;
import org.jboss.seam.remoting.Call;
import org.jboss.seam.remoting.MarshalUtils;
import org.jboss.seam.remoting.RequestContext;
import org.jboss.seam.remoting.RequestHandler;
import org.jboss.seam.remoting.WriteHeaderEvent;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.solder.logging.Logger;

public class ExecutionHandler
extends AbstractRequestHandler
implements RequestHandler {
    private static final Logger log = Logger.getLogger(ExecutionHandler.class);
    @Inject
    BeanManager beanManager;
    @Inject
    Conversation conversation;
    @Inject
    Event<WriteHeaderEvent> writeHeaderEvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("text/xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int read = request.getInputStream().read(buffer);
        while (read != -1) {
            out.write(buffer, 0, read);
            read = request.getInputStream().read(buffer);
        }
        String requestData = new String(out.toByteArray());
        log.debug((Object)("Processing remote request: " + requestData));
        SAXReader xmlReader = new SAXReader();
        Document doc = xmlReader.read((Reader)new StringReader(requestData));
        Element env = doc.getRootElement();
        RequestContext ctx = new RequestContext(env.element("header"));
        try {
            this.activateConversationContext(request, ctx.getConversationId());
            Call call = this.unmarshalCall(env);
            call.execute();
            if (call.getException() != null) {
                log.error((Object)"Error while executing call", call.getException());
            }
            try {
                ctx.setConversationId(this.conversation.isTransient() ? null : this.conversation.getId());
            }
            catch (ContextNotActiveException ex) {
                // empty catch block
            }
            this.marshalResponse(call, ctx, (OutputStream)response.getOutputStream());
        }
        finally {
            this.deactivateConversationContext(request);
        }
    }

    private Call unmarshalCall(Element env) throws Exception {
        try {
            Element callElement = env.element("body").element("call");
            Element targetNode = callElement.element("target");
            Element qualifiersNode = callElement.element("qualifiers");
            Element methodNode = callElement.element("method");
            Call call = new Call(this.beanManager, targetNode.getText(), qualifiersNode != null ? qualifiersNode.getText() : null, methodNode.getText());
            Element refsNode = callElement.element("refs");
            Iterator iter = refsNode.elementIterator("ref");
            while (iter.hasNext()) {
                call.getContext().createWrapperFromElement((Element)iter.next());
            }
            for (Wrapper w : call.getContext().getInRefs().values()) {
                w.unmarshal();
            }
            Element paramsNode = callElement.element("params");
            iter = paramsNode.elementIterator("param");
            while (iter.hasNext()) {
                Element param = (Element)iter.next();
                call.addParameter(call.getContext().createWrapperFromElement((Element)param.elementIterator().next()));
            }
            return call;
        }
        catch (Exception ex) {
            log.error((Object)"Error unmarshalling calls from request", (Throwable)ex);
            throw ex;
        }
    }

    private void marshalResponse(Call call, RequestContext ctx, OutputStream out) throws IOException {
        out.write(ENVELOPE_TAG_OPEN);
        out.write(HEADER_OPEN);
        this.writeHeaderEvent.fire((Object)new WriteHeaderEvent(out));
        out.write(CONTEXT_TAG_OPEN);
        if (ctx.getConversationId() != null) {
            out.write(CONVERSATION_ID_TAG_OPEN);
            out.write(ctx.getConversationId().getBytes());
            out.write(CONVERSATION_ID_TAG_CLOSE);
        }
        out.write(CALL_ID_TAG_OPEN);
        out.write(ctx.getCallId().toString().getBytes());
        out.write(CALL_ID_TAG_CLOSE);
        out.write(CONTEXT_TAG_CLOSE);
        out.write(HEADER_CLOSE);
        out.write(BODY_TAG_OPEN);
        MarshalUtils.marshalCallResult(call, out);
        out.write(BODY_TAG_CLOSE);
        out.write(ENVELOPE_TAG_CLOSE);
        out.flush();
    }
}

