/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.remoting.AnnotationsParser;
import org.jboss.seam.remoting.CallContext;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.remoting.util.Strings;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class Call {
    public static Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private BeanManager beanManager;
    private String methodName;
    private Throwable exception;
    private List<Wrapper> params = new ArrayList<Wrapper>();
    private Object result;
    private CallContext context;
    private List<String> constraints = null;
    private Bean<?> targetBean = null;

    public Call(BeanManager beanManager, String beanName, String qualifiers, String methodName) {
        this.beanManager = beanManager;
        this.methodName = methodName;
        this.context = new CallContext(beanManager);
        Set beans = beanManager.getBeans(beanName);
        if (beans.isEmpty()) {
            try {
                Class<?> beanType = Class.forName(beanName);
                Annotation[] q = qualifiers != null && !Strings.isEmpty(qualifiers) ? new AnnotationsParser(beanType, qualifiers, beanManager).getAnnotations() : EMPTY_ANNOTATIONS;
                beans = beanManager.getBeans(beanType, q);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid bean class specified: " + beanName);
            }
            if (beans.isEmpty()) {
                throw new IllegalArgumentException("Could not find bean with bean with type/name " + beanName + ", qualifiers [" + qualifiers + "]");
            }
        }
        this.targetBean = (Bean)beans.iterator().next();
    }

    public CallContext getContext() {
        return this.context;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void addParameter(Wrapper param) {
        this.params.add(param);
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public List<String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<String> constraints) {
        this.constraints = constraints;
    }

    public void execute() throws Exception {
        CreationalContext ctx = this.beanManager.createCreationalContext(this.targetBean);
        Object instance = this.beanManager.getReference(this.targetBean, (Type)this.targetBean.getBeanClass(), ctx);
        if (instance == null) {
            throw new RuntimeException(String.format("Could not create instance of bean %s", this.targetBean.getBeanClass().getName()));
        }
        Method m = this.findMethod(this.methodName, this.targetBean.getBeanClass());
        if (m == null) {
            throw new RuntimeException("No compatible method found.");
        }
        if (m.getAnnotation(WebRemote.class).exclude().length > 0) {
            this.constraints = Arrays.asList(m.getAnnotation(WebRemote.class).exclude());
        }
        Object[] params = this.convertParams(m.getGenericParameterTypes());
        try {
            this.result = m.invoke(instance, params);
        }
        catch (InvocationTargetException e) {
            this.exception = e.getCause();
        }
    }

    private Object[] convertParams(Type[] targetTypes) throws ConversionException {
        Object[] paramValues = new Object[targetTypes.length];
        for (int i = 0; i < targetTypes.length; ++i) {
            paramValues[i] = this.params.get(i).convert(targetTypes[i]);
        }
        return paramValues;
    }

    private Method findMethod(String name, Class<?> cls) {
        HashMap<Method, Integer> candidates = new HashMap<Method, Integer>();
        for (Method m : cls.getDeclaredMethods()) {
            if (m.getAnnotation(WebRemote.class) == null || !name.equals(m.getName()) || m.getParameterTypes().length != this.params.size()) continue;
            int score = 0;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                ConversionScore convScore = this.params.get(i).conversionScore(m.getParameterTypes()[i]);
                if (convScore == ConversionScore.nomatch) continue;
                score += convScore.getScore();
            }
            candidates.put(m, score);
        }
        Method bestMethod = null;
        int bestScore = 0;
        for (Map.Entry entry : candidates.entrySet()) {
            int thisScore = (Integer)entry.getValue();
            if (bestMethod != null && thisScore <= bestScore) continue;
            bestMethod = (Method)entry.getKey();
            bestScore = thisScore;
        }
        return bestMethod;
    }
}

