/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.remoting.AnnotationInvocationHandler;
import org.jboss.seam.remoting.annotationparser.AnnotationParser;
import org.jboss.seam.remoting.annotationparser.ParseException;
import org.jboss.seam.remoting.annotationparser.syntaxtree.Annotation;
import org.jboss.seam.remoting.annotationparser.syntaxtree.AnnotationsUnit;
import org.jboss.seam.remoting.annotationparser.syntaxtree.BooleanLiteral;
import org.jboss.seam.remoting.annotationparser.syntaxtree.ClassOrInterfaceType;
import org.jboss.seam.remoting.annotationparser.syntaxtree.Literal;
import org.jboss.seam.remoting.annotationparser.syntaxtree.MarkerAnnotation;
import org.jboss.seam.remoting.annotationparser.syntaxtree.MemberValue;
import org.jboss.seam.remoting.annotationparser.syntaxtree.MemberValuePair;
import org.jboss.seam.remoting.annotationparser.syntaxtree.MemberValuePairs;
import org.jboss.seam.remoting.annotationparser.syntaxtree.Name;
import org.jboss.seam.remoting.annotationparser.syntaxtree.Node;
import org.jboss.seam.remoting.annotationparser.syntaxtree.NodeListOptional;
import org.jboss.seam.remoting.annotationparser.syntaxtree.NodeOptional;
import org.jboss.seam.remoting.annotationparser.syntaxtree.NodeSequence;
import org.jboss.seam.remoting.annotationparser.syntaxtree.NodeToken;
import org.jboss.seam.remoting.annotationparser.syntaxtree.NormalAnnotation;
import org.jboss.seam.remoting.annotationparser.syntaxtree.SingleMemberAnnotation;
import org.jboss.seam.remoting.annotationparser.visitor.DepthFirstVisitor;

public class AnnotationsParser
extends DepthFirstVisitor {
    private Class<?> beanType;
    private BeanManager beanManager;
    private List<AnnotationMetadata> meta = new ArrayList<AnnotationMetadata>();
    private java.lang.annotation.Annotation[] annotations;

    public AnnotationsParser(Class<?> beanType, String declaration, BeanManager beanManager) {
        this.beanType = beanType;
        this.beanManager = beanManager;
        AnnotationParser parser = new AnnotationParser(new StringReader(declaration));
        try {
            AnnotationsUnit root = parser.AnnotationsUnit();
            root.accept(this);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error while parsing annotation declaration: " + declaration, e);
        }
        this.annotations = new java.lang.annotation.Annotation[this.meta.size()];
        for (int i = 0; i < this.meta.size(); ++i) {
            AnnotationMetadata ann = this.meta.get(i);
            AnnotationInvocationHandler handler = new AnnotationInvocationHandler(ann.getAnnotationType(), ann.getMemberValues());
            this.annotations[i] = (java.lang.annotation.Annotation)Proxy.newProxyInstance(ann.getAnnotationType().getClassLoader(), new Class[]{ann.getAnnotationType()}, (InvocationHandler)handler);
        }
        this.meta = null;
    }

    public java.lang.annotation.Annotation[] getAnnotations() {
        return this.annotations;
    }

    private Class<? extends java.lang.annotation.Annotation> determineAnnotationType(String name, Class<?> beanType) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            for (java.lang.annotation.Annotation beanAnnotation : beanType.getAnnotations()) {
                if (!name.equals(beanAnnotation.annotationType().getSimpleName())) continue;
                return beanAnnotation.annotationType();
            }
            Set beans = this.beanManager.getBeans(beanType, new java.lang.annotation.Annotation[]{new AnyQualifier()});
            for (Bean bean : beans) {
                for (java.lang.annotation.Annotation beanAnnotation : bean.getBeanClass().getAnnotations()) {
                    if (!name.equals(beanAnnotation.annotationType().getSimpleName())) continue;
                    return beanAnnotation.annotationType();
                }
            }
            if ("Default".equals(name)) {
                return Default.class;
            }
            if ("Any".equals(name)) {
                return Any.class;
            }
            return null;
        }
    }

    @Override
    public void visit(AnnotationsUnit node) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        NodeOptional n = node.f0;
        if (n.present() && n.node instanceof NodeSequence) {
            NodeSequence ns = (NodeSequence)n.node;
            for (Node nsNode : ns.nodes) {
                NodeListOptional nlo;
                if (nsNode instanceof Annotation) {
                    annotations.add((Annotation)nsNode);
                    continue;
                }
                if (!(nsNode instanceof NodeListOptional) || !(nlo = (NodeListOptional)nsNode).present()) continue;
                for (Node nloNode : nlo.nodes) {
                    if (!(nloNode instanceof NodeSequence)) continue;
                    for (Node cn : ((NodeSequence)nloNode).nodes) {
                        if (!(cn instanceof Annotation)) continue;
                        annotations.add((Annotation)cn);
                    }
                }
            }
        }
        for (Annotation a : annotations) {
            this.processAnnotation(a);
        }
        super.visit(node);
    }

    private void processAnnotation(Annotation node) {
        if (node.f0.choice instanceof MarkerAnnotation) {
            this.meta.add(new AnnotationMetadata(this.extractName(((MarkerAnnotation)node.f0.choice).f1)));
        } else if (node.f0.choice instanceof NormalAnnotation) {
            NormalAnnotation ann = (NormalAnnotation)node.f0.choice;
            AnnotationMetadata metadata = new AnnotationMetadata(this.extractName(ann.f1));
            if (ann.f3.present() && ann.f3.node instanceof MemberValuePairs) {
                MemberValuePairs mvp = (MemberValuePairs)ann.f3.node;
                this.extractMemberValue(metadata, mvp.f0.f0.tokenImage, mvp.f0.f2);
                if (mvp.f1.present()) {
                    for (Node n : mvp.f1.nodes) {
                        if (!(n instanceof NodeSequence)) continue;
                        for (Node nsn : ((NodeSequence)n).nodes) {
                            if (!(nsn instanceof MemberValuePair)) continue;
                            MemberValuePair p = (MemberValuePair)nsn;
                            this.extractMemberValue(metadata, p.f0.tokenImage, p.f2);
                        }
                    }
                }
            }
            this.meta.add(metadata);
        } else if (node.f0.choice instanceof SingleMemberAnnotation) {
            AnnotationMetadata metadata = new AnnotationMetadata(this.extractName(((SingleMemberAnnotation)node.f0.choice).f1));
            this.extractMemberValue(metadata, "value", ((SingleMemberAnnotation)node.f0.choice).f3);
            this.meta.add(metadata);
        }
    }

    private void extractMemberValue(AnnotationMetadata metadata, String memberName, MemberValue memberValue) {
        Class<?> memberType = null;
        for (Method m : metadata.getAnnotationType().getMethods()) {
            if (!memberName.equals(m.getName())) continue;
            memberType = m.getReturnType();
            break;
        }
        if (memberType == null) {
            throw new RuntimeException("Annotation member " + memberName + " not found on annotation type " + metadata.getAnnotationType().getName());
        }
        Object value = null;
        switch (memberValue.f0.which) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                value = this.convertLiteral((Literal)memberValue.f0.choice);
                break;
            }
            case 3: {
                value = this.convertClassOrInterfaceType((ClassOrInterfaceType)memberValue.f0.choice, memberType);
            }
        }
        metadata.addMemberValue(memberName, value);
    }

    private Object convertLiteral(Literal literal) {
        switch (literal.f0.which) {
            case 0: {
                return Integer.parseInt(((NodeToken)literal.f0.choice).tokenImage);
            }
            case 1: {
                return Float.valueOf(Float.parseFloat(((NodeToken)literal.f0.choice).tokenImage));
            }
            case 2: {
                return Character.valueOf(((NodeToken)literal.f0.choice).tokenImage.charAt(1));
            }
            case 3: {
                String stringVal = ((NodeToken)literal.f0.choice).tokenImage;
                return stringVal.substring(1, stringVal.length() - 1);
            }
            case 4: {
                return "true".equals(((NodeToken)((BooleanLiteral)literal.f0.choice).f0.choice).tokenImage);
            }
            case 5: {
                return null;
            }
        }
        return null;
    }

    private Object convertClassOrInterfaceType(ClassOrInterfaceType node, Class<?> memberType) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.f0.tokenImage);
        if (node.f1.present()) {
            for (Node n : node.f1.nodes) {
                if (!(n instanceof NodeSequence)) continue;
                for (Node nsn : ((NodeSequence)n).nodes) {
                    if (!(nsn instanceof NodeToken)) continue;
                    sb.append(((NodeToken)nsn).tokenImage);
                }
            }
        }
        String className = sb.toString();
        if (memberType.isEnum()) {
            for (Object e : memberType.getEnumConstants()) {
                if (!className.equals(((Enum)e).name())) continue;
                return e;
            }
            throw new IllegalArgumentException("Invalid enum specified for annotation member value: " + className);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (!className.startsWith("java.lang.")) {
                try {
                    return Class.forName("java.lang." + className);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Invalid class name specified for annotation member value: " + className);
        }
    }

    private String extractName(Name name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name.f0.tokenImage);
        NodeListOptional nodeList = name.f1;
        if (nodeList.present()) {
            for (Node node : nodeList.nodes) {
                if (!(node instanceof NodeSequence)) continue;
                for (Node n : ((NodeSequence)node).nodes) {
                    if (!(n instanceof NodeToken)) continue;
                    sb.append(((NodeToken)n).tokenImage);
                }
            }
        }
        return sb.toString();
    }

    private class AnyQualifier
    extends AnnotationLiteral<Any>
    implements Any {
        private AnyQualifier() {
        }
    }

    protected class AnnotationMetadata {
        private Class<? extends java.lang.annotation.Annotation> annotationType;
        private Map<String, Object> memberValues = new HashMap<String, Object>();

        public AnnotationMetadata(String name) {
            this.annotationType = AnnotationsParser.this.determineAnnotationType(name, AnnotationsParser.this.beanType);
        }

        public void addMemberValue(String name, Object value) {
            this.memberValues.put(name, value);
        }

        public Map<String, Object> getMemberValues() {
            return this.memberValues;
        }

        public Class<? extends java.lang.annotation.Annotation> getAnnotationType() {
            return this.annotationType;
        }
    }
}

