/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class AnnotationInvocationHandler
implements InvocationHandler {
    private Class<? extends Annotation> annotationType;
    private Map<String, Object> memberValues;

    public AnnotationInvocationHandler(Class<? extends Annotation> annotationType, Map<String, Object> memberValues) {
        this.annotationType = annotationType;
        this.memberValues = memberValues;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("annotationType".equals(method.getName())) {
            return this.annotationType;
        }
        if ("equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if ("hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName())) {
            return this.toString();
        }
        return this.memberValues.get(method.getName());
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('@').append(this.annotationType.getName()).append('(');
        for (int i = 0; i < this.annotationType.getDeclaredMethods().length; ++i) {
            int j;
            string.append(this.annotationType.getDeclaredMethods()[i].getName()).append('=');
            Object value = this.memberValues.get(this.annotationType.getDeclaredMethods()[i].getName());
            if (value instanceof boolean[]) {
                this.appendInBraces(string, Arrays.toString((boolean[])value));
            } else if (value instanceof byte[]) {
                this.appendInBraces(string, Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                this.appendInBraces(string, Arrays.toString((short[])value));
            } else if (value instanceof int[]) {
                this.appendInBraces(string, Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                this.appendInBraces(string, Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                this.appendInBraces(string, Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                this.appendInBraces(string, Arrays.toString((double[])value));
            } else if (value instanceof char[]) {
                this.appendInBraces(string, Arrays.toString((char[])value));
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                Object[] quoted = new String[strings.length];
                for (j = 0; j < strings.length; ++j) {
                    quoted[j] = "\"" + strings[j] + "\"";
                }
                this.appendInBraces(string, Arrays.toString(quoted));
            } else if (value instanceof Class[]) {
                Class[] classes = (Class[])value;
                Object[] names = new String[classes.length];
                for (j = 0; j < classes.length; ++j) {
                    names[j] = classes[j].getName() + ".class";
                }
                this.appendInBraces(string, Arrays.toString(names));
            } else if (value instanceof Object[]) {
                this.appendInBraces(string, Arrays.toString((Object[])value));
            } else if (value instanceof String) {
                string.append('\"').append(value).append('\"');
            } else if (value instanceof Class) {
                string.append(((Class)value).getName()).append(".class");
            } else {
                string.append(value);
            }
            if (i >= this.annotationType.getDeclaredMethods().length - 1) continue;
            string.append(", ");
        }
        return string.append(')').toString();
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('{').append(s.substring(1, s.length() - 1)).append('}');
    }

    public boolean equals(Object other) {
        Annotation that;
        if (other instanceof Annotation && this.annotationType.equals((that = (Annotation)other).annotationType())) {
            for (Method member : this.annotationType.getDeclaredMethods()) {
                Object thisValue = this.memberValues.get(member.getName());
                Object thatValue = AnnotationInvocationHandler.invoke(member, that);
                if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !thisValue.equals(thatValue))))))))))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.annotationType.getDeclaredMethods()) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            Object value = this.memberValues.get(member.getName());
            int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }
}

