/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.drools.base.TypeResolver;
import org.drools.common.InternalWorkingMemory;
import org.drools.ide.common.client.modeldriven.testing.ActivateRuleFlowGroup;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.server.testscenarios.ScenarioSettings;
import org.drools.ide.common.server.testscenarios.TestScenarioWorkingMemoryWrapper;
import org.drools.ide.common.server.testscenarios.populators.FactPopulator;
import org.drools.ide.common.server.testscenarios.populators.FactPopulatorFactory;
import org.mvel2.MVEL;

public class ScenarioRunner {
    private final TestScenarioWorkingMemoryWrapper workingMemoryWrapper;
    private final FactPopulatorFactory factPopulatorFactory;
    private final FactPopulator factPopulator;

    public ScenarioRunner(TypeResolver typeResolver, ClassLoader classLoader, InternalWorkingMemory workingMemory) throws ClassNotFoundException {
        HashMap<String, Object> populatedData = new HashMap<String, Object>();
        HashMap<String, Object> globalData = new HashMap<String, Object>();
        this.workingMemoryWrapper = new TestScenarioWorkingMemoryWrapper(workingMemory, typeResolver, classLoader, populatedData, globalData);
        this.factPopulatorFactory = new FactPopulatorFactory(populatedData, globalData, typeResolver, classLoader);
        this.factPopulator = new FactPopulator(workingMemory, populatedData);
    }

    public void run(Scenario scenario) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        scenario.setLastRunResult(new Date());
        this.populateGlobals(scenario.getGlobals());
        this.applyFixtures(scenario.getFixtures(), this.createScenarioSettings(scenario));
    }

    private ScenarioSettings createScenarioSettings(Scenario scenario) {
        ScenarioSettings scenarioSettings = new ScenarioSettings();
        scenarioSettings.setRuleList(scenario.getRules());
        scenarioSettings.setInclusive(scenario.isInclusive());
        scenarioSettings.setMaxRuleFirings(this.getMaxRuleFirings(scenario));
        return scenarioSettings;
    }

    private int getMaxRuleFirings(Scenario scenario) {
        String property = System.getProperty("guvnor.testscenario.maxrulefirings");
        if (property == null) {
            return scenario.getMaxRuleFirings();
        }
        return Integer.parseInt(property);
    }

    private void applyFixtures(List<Fixture> fixtures, ScenarioSettings scenarioSettings) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (Fixture fixture : fixtures) {
            if (fixture instanceof FactData) {
                this.factPopulator.add(this.factPopulatorFactory.createFactPopulator((FactData)fixture));
                continue;
            }
            if (fixture instanceof RetractFact) {
                this.factPopulator.retractFact(((RetractFact)fixture).getName());
                continue;
            }
            if (fixture instanceof CallMethod) {
                this.workingMemoryWrapper.executeMethod((CallMethod)fixture);
                continue;
            }
            if (fixture instanceof ActivateRuleFlowGroup) {
                this.workingMemoryWrapper.activateRuleFlowGroup(((ActivateRuleFlowGroup)fixture).getName());
                continue;
            }
            if (fixture instanceof ExecutionTrace) {
                this.factPopulator.populate();
                this.workingMemoryWrapper.executeSubScenario((ExecutionTrace)fixture, scenarioSettings);
                continue;
            }
            if (fixture instanceof Expectation) {
                this.factPopulator.populate();
                this.workingMemoryWrapper.verifyExpectation((Expectation)fixture);
                continue;
            }
            throw new IllegalArgumentException("Not sure what to do with " + fixture);
        }
        this.factPopulator.populate();
    }

    private void populateGlobals(List<FactData> globals) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (FactData fact : globals) {
            this.factPopulator.add(this.factPopulatorFactory.createGlobalFactPopulator(fact));
        }
        this.factPopulator.populate();
    }
}

