/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.weld.bean.interceptor.WeldAnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.DefaultMethodMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;

public class WeldInterceptorClassMetadata<T>
implements ClassMetadata<T>,
Serializable {
    private static final long serialVersionUID = -5087425231467781559L;
    private Class<T> clazz;
    private WeldInterceptorClassMetadata<?> superclass;
    private Collection<MethodMetadata> methodMetadatas;

    private WeldInterceptorClassMetadata(WeldClass<T> weldClass) {
        this.clazz = weldClass.getJavaClass();
        this.methodMetadatas = new ArrayList<MethodMetadata>();
        for (WeldMethod<?, T> method : weldClass.getDeclaredWeldMethods()) {
            MethodMetadata methodMetadata = DefaultMethodMetadata.of(method, WeldAnnotatedMethodReader.getInstance());
            if (methodMetadata.getSupportedInterceptionTypes() == null || methodMetadata.getSupportedInterceptionTypes().size() == 0) continue;
            this.methodMetadatas.add(methodMetadata);
        }
        if (weldClass.getWeldSuperclass() != null) {
            this.superclass = WeldInterceptorClassMetadata.of(weldClass.getWeldSuperclass());
        }
    }

    public static <T> WeldInterceptorClassMetadata<T> of(WeldClass<T> weldClass) {
        return new WeldInterceptorClassMetadata<T>(weldClass);
    }

    @Override
    public String getClassName() {
        return this.clazz.getName();
    }

    @Override
    public Iterable<MethodMetadata> getDeclaredMethods() {
        return this.methodMetadatas;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.clazz;
    }

    @Override
    public ClassMetadata<?> getSuperclass() {
        return this.superclass;
    }
}

