/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPrintStream
extends PrintStream {
    private Logger logger;
    private StringBuilder buffer = new StringBuilder();
    private boolean isError = false;

    public LoggingPrintStream(OutputStream outputStream, boolean isError) {
        super(outputStream);
        this.isError = isError;
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        try {
            this.logger = LoggerFactory.getLogger(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
    }

    protected void log(String s) {
        if (this.isError) {
            this.logger.error(s);
        } else {
            this.logger.info(s);
        }
    }

    private void write(String s) {
        this.buffer.append(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.log(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
        }
    }

    @Override
    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        LoggingPrintStream loggingPrintStream = this;
        synchronized (loggingPrintStream) {
            this.print(x);
            this.newLine();
        }
    }

    public static void interceptSysOutSysErr() {
        System.setOut(new LoggingPrintStream(System.out, false));
        System.setErr(new LoggingPrintStream(System.err, true));
    }

    public static void resetInterceptSysOutSysErr() {
        System.setOut(System.out);
        System.setErr(System.err);
    }
}

