/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.GlobalResolver;
import org.jbpm.process.instance.impl.Action;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAction
implements Action,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;

    public MVELAction() {
    }

    public MVELAction(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    public void compile(MVELDialectRuntimeData data) {
        this.expr = this.unit.getCompiledExpression(data);
    }

    public String getDialect() {
        return this.id;
    }

    @Override
    public void execute(ProcessContext context) throws Exception {
        int length = this.unit.getOtherIdentifiers().length;
        Object[] vars = new Object[length];
        if (this.unit.getOtherIdentifiers() != null) {
            for (int i = 0; i < length; ++i) {
                vars[i] = context.getVariable(this.unit.getOtherIdentifiers()[i]);
            }
        }
        ReteooWorkingMemoryInterface internalWorkingMemory = null;
        if (context.getKieRuntime() instanceof StatefulKnowledgeSessionImpl) {
            internalWorkingMemory = ((StatefulKnowledgeSessionImpl)context.getKieRuntime()).session;
        } else if (context.getKieRuntime() instanceof StatelessKnowledgeSessionImpl) {
            StatefulKnowledgeSession statefulKnowledgeSession = ((StatelessKnowledgeSessionImpl)context.getKieRuntime()).newWorkingMemory();
            internalWorkingMemory = ((StatefulKnowledgeSessionImpl)statefulKnowledgeSession).session;
        }
        VariableResolverFactory factory = this.unit.getFactory((Object)context, null, null, null, null, vars, (InternalWorkingMemory)internalWorkingMemory, (GlobalResolver)context.getKieRuntime().getGlobals());
        MVEL.executeExpression((Object)this.expr, null, (VariableResolverFactory)factory);
    }

    public Serializable getCompExpr() {
        return this.expr;
    }
}

