/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.FileChangeEvent;
import com.gentlyweb.utils.FileChangeListener;
import com.gentlyweb.utils.FileDetails;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileWatcher {
    private Map files = new HashMap();
    private Worker w = new Worker(this);

    public void addFile(File f) {
        if (!this.files.containsKey(f)) {
            this.files.put(f, new FileDetails(f));
        }
    }

    public void removeFile(File f) {
        this.files.remove(f);
    }

    public void clearAll() {
        this.files.clear();
    }

    public void addAll(File dir, FileFilter ff) {
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.canRead()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (this.files.containsKey(files[i])) continue;
            if (ff == null) {
                this.files.put(files[i], new FileDetails(files[i]));
                continue;
            }
            if (!ff.accept(files[i])) continue;
            this.files.put(files[i], new FileDetails(files[i]));
        }
    }

    public synchronized void removeAll(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        if (!dir.canRead()) {
            return;
        }
        HashMap newFs = new HashMap();
        Iterator iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            File pFile = f.getParentFile();
            if (pFile.equals(dir)) continue;
            newFs.put(f, this.files.get(f));
        }
    }

    public synchronized void removeAll(FileFilter ff) {
        HashMap newFs = new HashMap();
        Iterator iter = this.files.keySet().iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (ff.accept(f)) continue;
            newFs.put(f, this.files.get(f));
        }
        this.files = newFs;
    }

    protected synchronized Map getFiles() {
        HashMap fs = new HashMap();
        fs.putAll(this.files);
        return fs;
    }

    protected synchronized void setFileDetails(File f, FileDetails fd) {
        this.files.put(f, fd);
    }

    public void setCheckRepeatTime(long millis) {
        this.w.setCheckRepeatTime(millis);
    }

    public void start() {
        this.w.start();
    }

    public void stop() {
        this.w.stop();
    }

    protected void fireFileChange(File file, FileChangeEvent event, int types) {
        this.w.fireFileChange(file, event, types);
    }

    public void removeFileChangeListener(FileChangeListener f) {
        this.w.removeFileChangeListener(f);
    }

    public void addFileChangeListener(FileChangeListener f, int changeTypes) {
        this.w.addFileChangeListener(f, changeTypes);
    }

    public void addFileChangeListener(FileChangeListener f) {
        this.w.addFileChangeListener(f);
    }

    protected class Worker
    implements Runnable {
        private boolean shouldRun = false;
        private List listeners = new ArrayList();
        private long sleepTime = 5000L;
        private FileWatcher fw = null;

        public Worker(FileWatcher fw) {
            this.fw = fw;
        }

        public void run() {
            while (this.shouldRun) {
                Map files = this.fw.getFiles();
                Iterator iter = files.keySet().iterator();
                while (iter.hasNext()) {
                    File f = (File)iter.next();
                    FileDetails fd = (FileDetails)files.get(f);
                    this.processFile(f, fd);
                }
                if (!this.shouldRun) continue;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception exception) {}
            }
        }

        private void processFile(File f, FileDetails det) {
            int types = 0;
            if (f.exists() != det.exists()) {
                types = f.exists() ? ++types : (types += 2);
            } else if (f.exists()) {
                if (f.lastModified() != det.lastModified()) {
                    types += 4;
                }
                if (f.isHidden() != det.isHidden()) {
                    types = f.isHidden() ? (types += 8) : (types += 16);
                }
                if (f.length() != det.getLength()) {
                    types += 32;
                }
                if (f.canRead() != det.canRead()) {
                    types = f.canRead() ? (types += 64) : (types += 128);
                }
                if (f.canWrite() != det.canWrite()) {
                    types = f.canWrite() ? (types += 256) : (types += 512);
                }
                if (f.isFile() != det.isFile()) {
                    types += 1024;
                }
            }
            if (types > 0 && this.shouldRun) {
                FileDetails newDetails = new FileDetails(f);
                FileChangeEvent e = new FileChangeEvent(f, newDetails, det, types);
                this.fireFileChange(f, e, types);
                this.fw.setFileDetails(f, newDetails);
            }
        }

        public void setCheckRepeatTime(long millis) {
            this.sleepTime = millis;
        }

        public void start() {
            if (!this.shouldRun) {
                this.shouldRun = true;
                Thread t = new Thread(this);
                t.setDaemon(true);
                t.start();
            }
        }

        public void stop() {
            this.shouldRun = false;
        }

        protected void fireFileChange(File file, FileChangeEvent event, int types) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                FileListener l = (FileListener)this.listeners.get(i);
                if (!l.hasEvents(types)) continue;
                l.listener.fileChanged(event, types);
            }
        }

        public void removeFileChangeListener(FileChangeListener f) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                FileListener fl = (FileListener)this.listeners.get(i);
                if (fl.listener != f) continue;
                this.listeners.remove(i);
                return;
            }
        }

        public void addFileChangeListener(FileChangeListener f, int changeTypes) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != f) continue;
                return;
            }
            this.listeners.add(new FileListener(f, changeTypes));
        }

        public void addFileChangeListener(FileChangeListener f) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (this.listeners.get(i) != f) continue;
                return;
            }
            this.listeners.add(new FileListener(f, -1));
        }
    }

    private class FileListener {
        private int types = -1;
        private FileChangeListener listener = null;

        private FileListener(FileChangeListener l, int types) {
            this.listener = l;
            this.types = types;
        }

        private boolean hasEvents(int types) {
            if (this.types < 0) {
                return true;
            }
            return (this.types & types) > 0;
        }
    }
}

