/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v22Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String comment;
    private String genre;
    private String trackNumber;

    public ID3v22Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV22TagIterator tags = new RawV22TagIterator(frame);
        while (tags.hasNext()) {
            int close;
            String rawGenre;
            int open;
            ID3v2Frame.RawTag tag = tags.next();
            if (tag.name.equals("TT2")) {
                this.title = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TP1")) {
                this.artist = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TAL")) {
                this.album = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TYE")) {
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TCM")) {
                this.composer = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("COM")) {
                this.comment = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TRK")) {
                this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (!tag.name.equals("TCO") || (open = (rawGenre = this.getTagString(tag.data, 0, tag.data.length)).indexOf("(")) >= (close = rawGenre.indexOf(")"))) continue;
            try {
                int genreID = Integer.parseInt(rawGenre.substring(open + 1, close));
                this.genre = ID3Tags.GENRES[genreID];
            }
            catch (NumberFormatException ignore) {}
        }
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    public boolean getTagsPresent() {
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComposer() {
        return this.composer;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getTrackNumber() {
        return this.trackNumber;
    }

    private class RawV22TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV22TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            iD3v2Frame.getClass();
            super(iD3v2Frame, 3, 3, 1, 0);
        }
    }
}

