/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleType;
import org.drools.repository.RulesRepository;
import org.drools.repository.security.PermissionManager;

@RequestScoped
public class RoleBasedPermissionStore
implements Serializable {
    @Inject
    @Preferred
    private RulesRepository rulesRepository;

    public RoleBasedPermissionStore() {
    }

    public RoleBasedPermissionStore(RulesRepository rulesRepository) {
        this.rulesRepository = rulesRepository;
    }

    public List<RoleBasedPermission> getRoleBasedPermissionsByUserName(String userName) {
        PermissionManager permissionManager = new PermissionManager(this.rulesRepository);
        ArrayList<RoleBasedPermission> permissions = new ArrayList<RoleBasedPermission>();
        Map perms = permissionManager.retrieveUserPermissions(userName);
        for (Map.Entry<String, List<String>> entry : perms.entrySet()) {
            this.resolvePermissionsAndAdd(userName, permissions, entry);
        }
        return permissions;
    }

    private void resolvePermissionsAndAdd(String userName, List<RoleBasedPermission> permissions, Map.Entry<String, List<String>> permEntry) {
        String roleType = permEntry.getKey();
        if (RoleType.ADMIN.getName().equals(roleType)) {
            permissions.add(new RoleBasedPermission(userName, RoleType.ADMIN.getName(), null, null));
        }
        List<String> permissionsPerRole = permEntry.getValue();
        for (String permissionPerRole : permissionsPerRole) {
            if (permissionPerRole.startsWith("package=")) {
                String packageName = permissionPerRole.substring("package=".length());
                permissions.add(new RoleBasedPermission(userName, roleType, packageName, null));
                continue;
            }
            if (!permissionPerRole.startsWith("category=")) continue;
            String categoryPath = permissionPerRole.substring("category=".length());
            permissions.add(new RoleBasedPermission(userName, roleType, null, categoryPath));
        }
    }

    public void addRoleBasedPermissionForTesting(String userName, RoleBasedPermission rbp) {
        PermissionManager permissionManager = new PermissionManager(this.rulesRepository);
        Map perms = permissionManager.retrieveUserPermissions(userName);
        Object permissionsPerRole = perms.get(rbp.getRole());
        ArrayList<String> permissionsPerRoleList = (ArrayList<String>)permissionsPerRole;
        if (permissionsPerRoleList == null) {
            permissionsPerRoleList = new ArrayList<String>();
        }
        if (rbp.getPackageName() != null) {
            permissionsPerRoleList.add("package=" + rbp.getPackageName());
        } else if (rbp.getCategoryPath() != null) {
            permissionsPerRoleList.add("category=" + rbp.getCategoryPath());
        }
        perms.put(rbp.getRole(), permissionsPerRoleList);
        permissionManager.updateUserPermissions(userName, perms);
    }

    public void clearAllRoleBasedPermissionsForTesting(String userName) {
        PermissionManager permissionManager = new PermissionManager(this.rulesRepository);
        permissionManager.updateUserPermissions(userName, new HashMap());
    }
}

