/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.repository;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.repository.RepositoryStartupService;
import org.drools.repository.RulesRepository;
import org.jboss.seam.security.Identity;
import org.picketlink.idm.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class RulesRepositoryManager {
    private static final String DEFAULT_USERNAME = "guest";
    private static final Logger log = LoggerFactory.getLogger(RulesRepositoryManager.class);

    public void logout(@Disposes @Preferred RulesRepository rulesRepository) {
        rulesRepository.logout();
    }

    private void doSecurityContextAssociation() {
    }

    @Produces
    @Preferred
    @RequestScoped
    public RulesRepository getRulesRepository(RepositoryStartupService repositoryStartupService, Identity identity) {
        String username;
        User user = identity.getUser();
        if (user == null) {
            log.warn("Creating RulesRepository with default username.");
            username = DEFAULT_USERNAME;
        } else {
            username = user.getId();
        }
        this.doSecurityContextAssociation();
        RulesRepository rulesRepository = new RulesRepository(repositoryStartupService.newSession(username));
        return rulesRepository;
    }
}

