/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.core.util.StringUtils;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.ModuleNameType;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.util.Discussion;
import org.drools.guvnor.server.util.ISO8601;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.mvel2.templates.TemplateRuntime;

public class FeedServlet
extends RepositoryServlet {
    private static final String VIEW_URL = "viewUrl";
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private Identity identity;

    protected void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            String url = request.getRequestURI();
            if (url.contains("feed/package")) {
                this.doAuthorizedAction(request, response, new RepositoryServlet.Command(){

                    @Override
                    public void execute() throws Exception {
                        FeedServlet.this.doPackageFeed(request, response);
                    }
                });
            } else if (url.contains("feed/category")) {
                this.doAuthorizedAction(request, response, new RepositoryServlet.Command(){

                    @Override
                    public void execute() throws Exception {
                        FeedServlet.this.doCategoryFeed(request, response);
                    }
                });
            } else if (url.contains("feed/discussion")) {
                this.doAuthorizedAction(request, response, new RepositoryServlet.Command(){

                    @Override
                    public void execute() throws Exception {
                        FeedServlet.this.doDiscussionFeed(request, response);
                    }
                });
            }
        }
        catch (AuthorizationException e) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"users\"");
            response.sendError(401);
        }
    }

    private void doDiscussionFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String assetName = request.getParameter("assetName");
        String packageName = request.getParameter("package");
        AssetItem asset = this.rulesRepository.loadModule(packageName).loadAsset(assetName);
        this.checkPackageReadPermission(asset.getModuleName());
        ArrayList<AtomFeed.AtomEntry> entries = new ArrayList<AtomFeed.AtomEntry>();
        entries.add(new AtomFeed.AtomEntry(request, asset));
        List<DiscussionRecord> drs = new Discussion().fromString(asset.getStringProperty("discussion"));
        for (DiscussionRecord dr : drs) {
            entries.add(new AtomFeed.AtomEntry(request, asset, dr));
        }
        AtomFeed feed = new AtomFeed("Discussion of: " + packageName + "/" + assetName, Calendar.getInstance(), request.getServerName() + "/" + packageName + "/" + assetName, request.getParameter(VIEW_URL), request.getRequestURL().toString(), entries, "A list of updated discussion content.");
        response.setContentType("application/atom+xml; charset=UTF-8");
        response.getWriter().print(feed.getAtom());
    }

    private void doCategoryFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cat = request.getParameter("name");
        String status = request.getParameter("status");
        this.checkCategoryPermission(cat);
        AssetItemPageResult pg = this.rulesRepository.findAssetsByCategory(cat, false, 0, -1);
        Iterator<AssetItem> it = pg.assets.iterator();
        ArrayList<AtomFeed.AtomEntry> entries = new ArrayList<AtomFeed.AtomEntry>();
        this.buildEntries(request, entries, it, status);
        AtomFeed feed = new AtomFeed("Category: " + cat, Calendar.getInstance(), request.getServerName() + cat, request.getParameter(VIEW_URL), request.getRequestURL().toString(), entries, "Guvnor category of items: " + cat);
        response.setContentType("application/atom+xml; charset=UTF-8");
        response.getWriter().print(feed.getAtom());
    }

    void checkCategoryPermission(String cat) {
        this.identity.checkPermission((Object)new CategoryPathType(cat), RoleType.ANALYST_READ.getName());
    }

    private void doPackageFeed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String packageName = request.getParameter("name");
        this.checkPackageReadPermission(packageName);
        ModuleItem pkg = this.rulesRepository.loadModule(packageName);
        ArrayList<AtomFeed.AtomEntry> entries = new ArrayList<AtomFeed.AtomEntry>();
        Iterator it = pkg.getAssets();
        this.buildEntries(request, entries, it, request.getParameter("status"));
        AtomFeed feed = new AtomFeed("Knowledge package: " + pkg.getName(), pkg.getLastModified(), pkg.getUUID(), request.getParameter(VIEW_URL), request.getRequestURL().toString(), entries, pkg.getDescription());
        response.setContentType("application/atom+xml; charset=UTF-8");
        response.getWriter().print(feed.getAtom());
    }

    private void buildEntries(HttpServletRequest request, List<AtomFeed.AtomEntry> entries, Iterator<AssetItem> it, String status) {
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.isArchived() || as.getDisabled() || status != null && !status.equals("*") && !as.getStateDescription().equals(status)) continue;
            entries.add(new AtomFeed.AtomEntry(request, as));
        }
    }

    void checkPackageReadPermission(String packageName) {
        this.identity.checkPermission((Object)new ModuleNameType(packageName), RoleType.PACKAGE_READONLY.getName());
    }

    public static class AtomFeed {
        private static final String TEMPLATE = StringUtils.readFileAsString((Reader)new InputStreamReader(AtomFeed.class.getResourceAsStream("/atom-feed-template.xml")));
        private final String feedTitle;
        private final String feedUpdated;
        private final String feedId;
        private final String feedAlternate;
        private final String feedSelf;
        private final String subtitle;
        private final Collection<AtomEntry> entries;

        public AtomFeed(String title, Calendar whenUpdate, String feedId, String feedAlternate, String feedSelf, Collection<AtomEntry> entries, String subtitle) {
            this.feedTitle = title;
            this.feedUpdated = ISO8601.format(whenUpdate);
            this.feedId = feedId;
            this.feedAlternate = feedAlternate;
            this.feedSelf = feedSelf;
            this.entries = entries;
            this.subtitle = subtitle;
        }

        public String getAtom() {
            HashMap<String, AtomFeed> m = new HashMap<String, AtomFeed>();
            m.put("feed", this);
            return (String)TemplateRuntime.eval((String)TEMPLATE, m);
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public Collection getEntries() {
            return this.entries;
        }

        public String getFeedTitle() {
            return this.feedTitle;
        }

        public String getFeedUpdated() {
            return this.feedUpdated;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getFeedAlternate() {
            return this.feedAlternate;
        }

        public String getFeedSelf() {
            return this.feedSelf;
        }

        public static class AtomEntry {
            private final String name;
            private final String webURL;
            private final String id;
            private final String updated;
            private final String published;
            private final String author;
            private final String contributor;
            private final String description;
            private final String checkinComment;
            private final String format;

            public AtomEntry(HttpServletRequest req, AssetItem asset) {
                this.name = asset.getName();
                this.format = asset.getFormat();
                this.webURL = req.getParameter(FeedServlet.VIEW_URL) + "#asset=" + asset.getUUID() + "%26nochrome";
                this.id = asset.getUUID();
                this.updated = ISO8601.format(asset.getLastModified());
                this.published = ISO8601.format(asset.getCreatedDate());
                this.author = asset.getCreator();
                this.contributor = asset.getLastContributor();
                this.description = asset.getDescription();
                this.checkinComment = asset.getCheckinComment();
            }

            public AtomEntry(HttpServletRequest req, AssetItem asset, DiscussionRecord discussionRec) {
                this.name = asset.getName();
                this.format = asset.getFormat();
                this.webURL = req.getParameter(FeedServlet.VIEW_URL) + "#asset=" + asset.getUUID() + "%26nochrome";
                this.id = asset.getUUID();
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(discussionRec.timestamp));
                this.updated = ISO8601.format(c);
                this.published = ISO8601.format(c);
                this.author = discussionRec.author;
                this.contributor = asset.getLastContributor();
                this.description = "Discussion comment was added by: " + discussionRec.author;
                String[] noteLines = discussionRec.note.split("\\r?\\n");
                String wn = "";
                for (int i = 0; i < noteLines.length; ++i) {
                    wn = wn + noteLines[i];
                    if (i == noteLines.length - 1) continue;
                    wn = wn + "<br/>";
                }
                this.checkinComment = wn;
            }

            public String getName() {
                return this.name;
            }

            public String getFormat() {
                return this.format;
            }

            public String getWebURL() {
                return this.webURL;
            }

            public String getId() {
                return this.id;
            }

            public String getUpdated() {
                return this.updated;
            }

            public String getPublished() {
                return this.published;
            }

            public String getAuthor() {
                return this.author;
            }

            public String getContributor() {
                return this.contributor;
            }

            public String getDescription() {
                return this.description;
            }

            public String getCheckinComment() {
                return this.checkinComment;
            }
        }
    }
}

