/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.rule.MapBackedClassLoader;

public class ModelContentHandler
extends ContentHandler
implements ICanHasAttachment {
    @Override
    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
    }

    @Override
    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
    }

    @Override
    public void onAttachmentAdded(AssetItem asset) throws IOException {
        ModuleItem pkg = asset.getModule();
        StringBuilder header = this.createNewHeader(DroolsHeader.getDroolsHeader(pkg));
        Set<String> imports = this.getImportsFromJar(asset);
        for (String importLine : imports) {
            Pattern pattern = Pattern.compile("\\s" + importLine.replace(".", "\\.") + "\\s");
            if (pattern.matcher(header).find()) continue;
            header.append(importLine).append("\n");
        }
        DroolsHeader.updateDroolsHeader(header.toString(), pkg);
        pkg.checkin("Imports setup automatically on model import.");
    }

    @Override
    public void onAttachmentRemoved(AssetItem item) throws IOException {
        ModuleItem pkg = item.getModule();
        StringBuilder header = this.createNewHeader(DroolsHeader.getDroolsHeader(pkg));
        Set<String> imports = this.getImportsFromJar(item);
        for (String importLine : imports) {
            String importLineWithLineEnd = importLine + "\n";
            header = this.removeImportIfItExists(header, importLineWithLineEnd);
        }
        DroolsHeader.updateDroolsHeader(header.toString(), pkg);
        pkg.checkin("Imports removed automatically on model archiving.");
    }

    private StringBuilder removeImportIfItExists(StringBuilder header, String importLine) {
        if (header.indexOf(importLine) >= 0) {
            int indexOfImportLine = header.indexOf(importLine);
            header = header.replace(indexOfImportLine, indexOfImportLine + importLine.length(), "");
        }
        return header;
    }

    private StringBuilder createNewHeader(String header) {
        StringBuilder buf = new StringBuilder();
        if (header != null) {
            buf.append(header);
            buf.append('\n');
        }
        return buf;
    }

    private Set<String> getImportsFromJar(AssetItem assetItem) throws IOException {
        HashSet<String> imports = new HashSet<String>();
        HashMap<String, String> nonCollidingImports = new HashMap<String, String>();
        String assetPackageName = assetItem.getModuleName();
        JarInputStream cljis = new JarInputStream(assetItem.getBinaryContentAttachment());
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(cljis);
        ClassLoaderBuilder clb = new ClassLoaderBuilder(jarInputStreams);
        MapBackedClassLoader cl = clb.buildClassLoader();
        JarInputStream jis = new JarInputStream(assetItem.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            String leafName;
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().endsWith("package-info.class")) continue;
            String fullyQualifiedName = ModelContentHandler.convertPathToName(entry.getName());
            String fullyQualifiedClassName = ModelContentHandler.convertPathToClassName(entry.getName());
            if (!this.isClassVisible((ClassLoader)cl, fullyQualifiedClassName, assetPackageName) || nonCollidingImports.containsKey(leafName = this.getLeafName(fullyQualifiedName))) continue;
            nonCollidingImports.put(leafName, fullyQualifiedName);
        }
        for (String value : nonCollidingImports.values()) {
            String line = "import " + value;
            imports.add(line);
        }
        return imports;
    }

    private String getLeafName(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(".");
        if (index == -1) {
            return fullyQualifiedName;
        }
        return fullyQualifiedName.substring(index + 1);
    }

    private boolean isClassVisible(ClassLoader cl, String className, String assetPackageName) {
        try {
            Class<?> cls = cl.loadClass(className);
            int modifiers = cls.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                return true;
            }
            String packageName = className.substring(0, className.lastIndexOf("."));
            if (!packageName.equals(assetPackageName)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static String convertPathToClassName(String name) {
        String convertedName = name.replace(".class", "");
        convertedName = convertedName.replace("/", ".");
        return convertedName;
    }

    public static String convertPathToName(String name) {
        String convertedName = ModelContentHandler.convertPathToClassName(name);
        convertedName = convertedName.replaceAll("\\$", ".");
        return convertedName;
    }
}

