/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.lang.dsl.DSLMappingParseException;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepositoryException;

public class DSLLoader {
    public static List<DSLTokenizedMappingFile> loadDSLMappingFiles(ModuleItem packageItem) {
        return DSLLoader.loadDSLMappingFiles(packageItem, new BRMSPackageBuilder.DSLErrorEvent(){

            @Override
            public void recordError(AssetItem asset, String message) {
            }
        });
    }

    public static List<DSLTokenizedMappingFile> loadDSLMappingFiles(ModuleItem packageItem, BRMSPackageBuilder.DSLErrorEvent dslErrorEvent) {
        return DSLLoader.loadDSLMappingFiles((Iterator<AssetItem>)packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"dsl"}), dslErrorEvent);
    }

    static List<DSLTokenizedMappingFile> loadDSLMappingFiles(Iterator<AssetItem> assetItemIterator, BRMSPackageBuilder.DSLErrorEvent dslErrorEvent) {
        ArrayList<DSLTokenizedMappingFile> result = new ArrayList<DSLTokenizedMappingFile>();
        while (assetItemIterator.hasNext()) {
            DSLLoader.addAsset(dslErrorEvent, result, assetItemIterator.next());
        }
        return result;
    }

    private static void addAsset(BRMSPackageBuilder.DSLErrorEvent dslErrorEvent, List<DSLTokenizedMappingFile> result, AssetItem assetItem) {
        if (!assetItem.getDisabled()) {
            DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
            try {
                if (file.parseAndLoad((Reader)new StringReader(assetItem.getContent()))) {
                    result.add(file);
                } else {
                    DSLLoader.logErrors(dslErrorEvent, assetItem, file);
                }
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
    }

    private static void logErrors(BRMSPackageBuilder.DSLErrorEvent dslErrorEvent, AssetItem assetItem, DSLTokenizedMappingFile file) {
        for (Object o : file.getErrors()) {
            if (o instanceof DSLMappingParseException) {
                DSLMappingParseException dslMappingParseException = (DSLMappingParseException)o;
                dslErrorEvent.recordError(assetItem, "Line " + dslMappingParseException.getLine() + " : " + dslMappingParseException.getMessage());
                continue;
            }
            if (o instanceof Exception) {
                Exception excp = (Exception)o;
                dslErrorEvent.recordError(assetItem, "Exception " + excp.getClass() + " " + excp.getMessage() + " " + excp.getCause());
                continue;
            }
            dslErrorEvent.recordError(assetItem, "Uncategorized error " + o);
        }
    }
}

