/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.wizards;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.Popup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.widgets.wizards.WizardActivityView;
import org.drools.guvnor.client.widgets.wizards.WizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardPage;
import org.drools.guvnor.client.widgets.wizards.WizardPageTitle;

public class WizardActivityViewImpl
extends Popup
implements WizardActivityView {
    @UiField
    protected VerticalPanel sideBar;
    @UiField
    protected SimplePanel sideBarContainer;
    @UiField
    ScrollPanel bodyContainer;
    @UiField
    protected SimplePanel body;
    @UiField
    protected Button btnNext;
    @UiField
    protected Button btnPrevious;
    @UiField
    protected Button btnFinish;
    private Widget content;
    private List<WizardPageTitle> pageTitleWidgets = new ArrayList<WizardPageTitle>();
    private int pageNumber;
    private int pageNumberTotal;
    private WizardActivityView.Presenter presenter;
    private WizardContext context;
    private EventBus eventBus;
    private static WizardActivityViewImplBinder uiBinder = (WizardActivityViewImplBinder)GWT.create(WizardActivityViewImplBinder.class);
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);

    public WizardActivityViewImpl(WizardContext context, EventBus eventBus) {
        this.context = context;
        this.eventBus = eventBus;
        this.content = (Widget)uiBinder.createAndBindUi(this);
    }

    @Override
    public Widget getContent() {
        return this.content;
    }

    @Override
    public void setPresenter(WizardActivityView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setPageTitles(List<WizardPage> pages) {
        this.pageNumberTotal = pages.size() - 1;
        for (WizardPage page : pages) {
            WizardPageTitle wpt = new WizardPageTitle(this.context, this.eventBus, page);
            this.pageTitleWidgets.add(wpt);
            this.sideBar.add((Widget)wpt);
        }
    }

    @UiHandler(value={"btnCancel"})
    public void btnCancelClick(ClickEvent event) {
        this.hide();
    }

    @UiHandler(value={"btnFinish"})
    public void btnFinishClick(ClickEvent event) {
        this.presenter.complete();
    }

    @UiHandler(value={"btnNext"})
    public void btnNextClick(ClickEvent event) {
        if (this.pageNumber == this.pageNumberTotal) {
            return;
        }
        this.selectPage(this.pageNumber + 1);
        this.btnNext.setFocus(false);
    }

    @UiHandler(value={"btnPrevious"})
    public void btnPreviousClick(ClickEvent event) {
        if (this.pageNumber == 0) {
            return;
        }
        this.selectPage(this.pageNumber - 1);
        this.btnPrevious.setFocus(false);
    }

    @Override
    public void selectPage(int pageNumber) {
        if (pageNumber < 0 || pageNumber > this.pageTitleWidgets.size() - 1) {
            return;
        }
        this.pageNumber = pageNumber;
        for (int i = 0; i < this.pageTitleWidgets.size(); ++i) {
            WizardPageTitle wpt = this.pageTitleWidgets.get(i);
            wpt.setPageSelected(i == pageNumber);
        }
        this.btnNext.setEnabled(pageNumber < this.pageNumberTotal);
        this.btnPrevious.setEnabled(pageNumber > 0);
        this.presenter.pageSelected(pageNumber);
    }

    @Override
    public void setBodyWidget(Widget w) {
        this.body.setWidget(w);
        this.center();
    }

    @Override
    public void setPreferredHeight(int height) {
        this.bodyContainer.setHeight(height + "px");
        this.sideBarContainer.setHeight(height + "px");
    }

    @Override
    public void setPreferredWidth(int width) {
        this.bodyContainer.setWidth(width + "px");
    }

    @Override
    public void setPageCompletionState(int pageIndex, boolean isComplete) {
        WizardPageTitle wpt = this.pageTitleWidgets.get(pageIndex);
        wpt.setComplete(isComplete);
    }

    @Override
    public void setCompletionStatus(boolean isComplete) {
        this.btnFinish.setEnabled(isComplete);
    }

    @Override
    public void showSavingIndicator() {
        LoadingPopup.showMessage(constants.SavingPleaseWait());
    }

    @Override
    public void hideSavingIndicator() {
        LoadingPopup.close();
    }

    @Override
    public void showDuplicateAssetNameError() {
        Window.alert((String)constants.AssetNameAlreadyExistsPickAnother());
    }

    @Override
    public void showUnspecifiedCheckinError() {
        ErrorPopup.showMessage(constants.FailedToCheckInTheItemPleaseContactYourSystemAdministrator());
    }

    @Override
    public void showCheckinError(String message) {
        ErrorPopup.showMessage(message);
    }

    static interface WizardActivityViewImplBinder
    extends UiBinder<Widget, WizardActivityViewImpl> {
    }
}

