/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;

public class SelectionColumn<T>
extends Column<T, Boolean> {
    private final CellTable<T> cellTable;

    public static <T> void createAndAddSelectionColumn(CellTable<T> cellTable) {
        SelectionColumn<T> selectionColumn = new SelectionColumn<T>(cellTable);
        cellTable.addColumn(selectionColumn, SafeHtmlUtils.fromSafeConstant((String)"<br>"));
    }

    public SelectionColumn(CellTable<T> cellTable) {
        super((Cell)new CheckboxCell(true));
        this.cellTable = cellTable;
        this.addUpdater();
    }

    private void addUpdater() {
        this.setFieldUpdater(new FieldUpdater<T, Boolean>(){

            public void update(int index, T object, Boolean value) {
                SelectionColumn.this.cellTable.getSelectionModel().setSelected(object, value.booleanValue());
            }
        });
    }

    public Boolean getValue(T object) {
        return this.cellTable.getSelectionModel().isSelected(object);
    }
}

