/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.moduleeditor.DependencyWidget;
import org.drools.guvnor.client.rpc.DependenciesPageRow;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.widgets.query.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.AbstractPagedTable;
import org.drools.guvnor.client.widgets.tables.AbstractSimpleTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SelectionColumn;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class DependenciesPagedTable
extends AbstractPagedTable<DependenciesPageRow> {
    private static DependenciesPagedTableBinder uiBinder = (DependenciesPagedTableBinder)GWT.create(DependenciesPagedTableBinder.class);
    private OpenItemCommand openSelectedCommand;
    private static final int PAGE_SIZE = 5;
    protected SingleSelectionModel<DependenciesPageRow> selectionModel;
    private final String uuid;

    public DependenciesPagedTable(String theUuid, OpenItemCommand openSelectedCommand) {
        super(5);
        this.openSelectedCommand = openSelectedCommand;
        this.uuid = theUuid;
        this.setDataProvider(new AsyncDataProvider<DependenciesPageRow>(){

            protected void onRangeChanged(HasData<DependenciesPageRow> display) {
                LoadingPopup.showMessage("please wait...");
                ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                moduleService.getDependencies(DependenciesPagedTable.this.uuid, (AsyncCallback<String[]>)new GenericCallback<String[]>(){

                    public void onSuccess(String[] dependencies) {
                        LoadingPopup.close();
                        ArrayList<DependenciesPageRow> dependencyList = new ArrayList<DependenciesPageRow>();
                        for (String dependency : dependencies) {
                            DependenciesPageRow row = new DependenciesPageRow();
                            row.setDependencyPath(DependencyWidget.decodeDependencyPath(dependency)[0]);
                            row.setDependencyVersion(DependencyWidget.decodeDependencyPath(dependency)[1]);
                            dependencyList.add(row);
                        }
                        this.updateRowCount(dependencyList.size(), true);
                        this.updateRowData(0, dependencyList);
                    }
                });
            }
        });
    }

    @Override
    public SingleSelectionModel<DependenciesPageRow> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    protected void doCellTable() {
        ProvidesKey<DependenciesPageRow> providesKey = new ProvidesKey<DependenciesPageRow>(){

            public Object getKey(DependenciesPageRow row) {
                return row.getDependencyPath();
            }
        };
        this.cellTable = new CellTable((ProvidesKey)providesKey);
        this.selectionModel = new SingleSelectionModel((ProvidesKey)providesKey);
        this.cellTable.setSelectionModel(this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn(this.cellTable);
        ColumnPicker<DependenciesPageRow> columnPicker = new ColumnPicker<DependenciesPageRow>(this.cellTable);
        SortableHeaderGroup<DependenciesPageRow> sortableHeaderGroup = new SortableHeaderGroup<DependenciesPageRow>(this.cellTable);
        this.addAncillaryColumns(columnPicker, sortableHeaderGroup);
        Column<DependenciesPageRow, String> openColumn = new Column<DependenciesPageRow, String>((Cell)new ButtonCell()){

            public String getValue(DependenciesPageRow row) {
                return AbstractSimpleTable.constants.Open();
            }
        };
        openColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DependenciesPageRow, String>(){

            public void update(int index, DependenciesPageRow row, String value) {
                DependenciesPagedTable.this.openSelectedCommand.open(DependencyWidget.encodeDependencyPath(row.getDependencyPath(), row.getDependencyVersion()));
            }
        });
        columnPicker.addColumn(openColumn, (Header<String>)new TextHeader(constants.Open()), true);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<DependenciesPageRow> columnPicker, SortableHeaderGroup<DependenciesPageRow> sortableHeaderGroup) {
        Column<DependenciesPageRow, String> dependencyPathColumn = new Column<DependenciesPageRow, String>((Cell)new TextCell()){

            public String getValue(DependenciesPageRow row) {
                return row.getDependencyPath();
            }
        };
        columnPicker.addColumn(dependencyPathColumn, new SortableHeader<DependenciesPageRow, String>(sortableHeaderGroup, "Dependency Path", dependencyPathColumn), true);
        Column<DependenciesPageRow, String> dependencyVersionColumn = new Column<DependenciesPageRow, String>((Cell)new TextCell()){

            public String getValue(DependenciesPageRow row) {
                return row.getDependencyVersion();
            }
        };
        columnPicker.addColumn(dependencyVersionColumn, new SortableHeader<DependenciesPageRow, String>(sortableHeaderGroup, "Dependency Version", dependencyVersionColumn), true);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"refreshButton"})
    void refresh(ClickEvent e) {
        this.refresh();
    }

    static interface DependenciesPagedTableBinder
    extends UiBinder<Widget, DependenciesPagedTable> {
    }
}

