/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.MultiViewRow;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.MultiAssetPlace;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.AbstractAssetPageRow;
import org.drools.guvnor.client.widgets.tables.AbstractPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SelectionColumn;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public abstract class AbstractAssetPagedTable<T extends AbstractAssetPageRow>
extends AbstractPagedTable<T> {
    protected static final ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static AssetPagedTableBinder uiBinder = (AssetPagedTableBinder)GWT.create(AssetPagedTableBinder.class);
    @UiField
    protected Image feedImage;
    protected Set<Command> unloadListenerSet = new HashSet<Command>();
    protected MultiSelectionModel<T> selectionModel;
    protected String feedURL;
    private final ClientFactory clientFactory;

    public AbstractAssetPagedTable(int pageSize, ClientFactory clientFactory) {
        this(pageSize, null, clientFactory);
    }

    public AbstractAssetPagedTable(int pageSize, String feedURL, ClientFactory clientFactory) {
        super(pageSize);
        this.feedURL = feedURL;
        if (this.feedURL == null || "".equals(feedURL)) {
            this.feedImage.setVisible(false);
        }
        this.clientFactory = clientFactory;
    }

    public void addUnloadListener(Command unloadListener) {
        this.unloadListenerSet.add(unloadListener);
    }

    public String[] getSelectedRowUUIDs() {
        Set selectedRows = this.selectionModel.getSelectedSet();
        if (selectedRows.size() == 0) {
            return null;
        }
        String[] uuids = new String[selectedRows.size()];
        int rowCount = 0;
        for (AbstractAssetPageRow row : selectedRows) {
            uuids[rowCount++] = row.getUuid();
        }
        return uuids;
    }

    @UiHandler(value={"archiveSelectedButton"})
    public void archiveSelectedAssets(ClickEvent e) {
        if (this.getSelectedRowUUIDs() == null) {
            Window.alert((String)constants.PleaseSelectAnItemToArchive());
            return;
        }
        if (!Window.confirm((String)constants.AreYouSureYouWantToArchiveTheseItems())) {
            return;
        }
        this.assetService.archiveAssets(this.getSelectedRowUUIDs(), true, new GenericCallback<Void>(){

            public void onSuccess(Void arg0) {
                Window.alert((String)constants.ArchivedAssets());
                AbstractAssetPagedTable.this.refresh();
            }
        });
    }

    @UiHandler(value={"openSelectedToSingleTabButton"})
    public void openSelectedToSingleTab(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        ArrayList<MultiViewRow> multiViewRowList = new ArrayList<MultiViewRow>(selectedSet.size());
        for (AbstractAssetPageRow selected : selectedSet) {
            multiViewRowList.add(new MultiViewRow(selected.getUuid(), selected.getName(), selected.getFormat()));
        }
        this.clientFactory.getPlaceController().goTo((Place)new MultiAssetPlace(multiViewRowList));
    }

    @Override
    public void refresh() {
        this.selectionModel.clear();
        this.cellTable.setVisibleRangeAndClearData(this.cellTable.getVisibleRange(), true);
    }

    @Override
    protected void doCellTable() {
        ProvidesKey providesKey = new ProvidesKey<T>(){

            public Object getKey(T row) {
                return ((AbstractAssetPageRow)row).getUuid();
            }
        };
        this.cellTable = new CellTable(providesKey);
        this.selectionModel = new MultiSelectionModel(providesKey);
        this.cellTable.setSelectionModel(this.selectionModel);
        SelectionColumn.createAndAddSelectionColumn(this.cellTable);
        ColumnPicker columnPicker = new ColumnPicker(this.cellTable);
        SortableHeaderGroup sortableHeaderGroup = new SortableHeaderGroup(this.cellTable);
        TextColumn uuidNumberColumn = new TextColumn<T>(){

            public String getValue(T row) {
                return ((AbstractAssetPageRow)row).getUuid();
            }
        };
        columnPicker.addColumn(uuidNumberColumn, new SortableHeader(sortableHeaderGroup, constants.uuid(), uuidNumberColumn), false);
        this.addAncillaryColumns(columnPicker, sortableHeaderGroup);
        Column openColumn = new Column<T, String>((Cell)new ButtonCell()){

            public String getValue(T row) {
                return constants.Open();
            }
        };
        openColumn.setFieldUpdater(new FieldUpdater<T, String>(){

            public void update(int index, T row, String value) {
                AbstractAssetPagedTable.this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(((AbstractAssetPageRow)row).getUuid()));
            }
        });
        columnPicker.addColumn(openColumn, (Header<String>)new TextHeader(constants.Open()), true);
        this.cellTable.setWidth("100%");
        this.columnPickerButton = columnPicker.createToggleButton();
    }

    protected void onUnload() {
        super.onUnload();
        for (Command unloadListener : this.unloadListenerSet) {
            unloadListener.execute();
        }
    }

    @Override
    public void setDataProvider(AsyncDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this.cellTable);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    @UiHandler(value={"feedImage"})
    void openFeed(ClickEvent e) {
        if (!this.feedImage.isVisible() || this.feedURL == null || "".equals(this.feedURL)) {
            return;
        }
        Window.open((String)this.feedURL, (String)"_blank", null);
    }

    @UiHandler(value={"openSelectedButton"})
    void openSelected(ClickEvent e) {
        Set selectedSet = this.selectionModel.getSelectedSet();
        for (AbstractAssetPageRow selected : selectedSet) {
            this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(selected.getUuid()));
        }
    }

    @UiHandler(value={"refreshButton"})
    void refresh(ClickEvent e) {
        this.refresh();
    }

    static interface AssetPagedTableBinder
    extends UiBinder<Widget, AbstractAssetPagedTable> {
    }
}

