/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.query;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.drools.guvnor.client.common.DatePickerTextBox;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.widgets.query.QuickFindWidget;
import org.drools.guvnor.client.widgets.tables.QueryPagedTable;

public class QueryWidget
extends Composite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private VerticalPanel layout;
    private final ClientFactory clientFactory;

    public QueryWidget(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.layout = new VerticalPanel();
        this.doQuickFind();
        this.doTextSearch();
        this.doMetaSearch();
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
        this.setWidth("100%");
    }

    private void doQuickFind() {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.constants.NameSearch());
        advancedDisclosure.ensureDebugId("cwDisclosurePanel");
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setContent((Widget)new QuickFindWidget(this.clientFactory));
        advancedDisclosure.setOpen(true);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void doTextSearch() {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.constants.TextSearch());
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(true);
        VerticalPanel container = new VerticalPanel();
        VerticalPanel criteria = new VerticalPanel();
        FormStyleLayout ts = new FormStyleLayout();
        final TextBox tx = new TextBox();
        ts.addAttribute(this.constants.SearchFor(), (Widget)tx);
        final CheckBox archiveBox = new CheckBox();
        archiveBox.setValue(Boolean.valueOf(false));
        ts.addAttribute(this.constants.IncludeArchivedAssetsInResults(), (Widget)archiveBox);
        Button go = new Button();
        go.setText(this.constants.Search1());
        ts.addAttribute("", (Widget)go);
        ts.setWidth("100%");
        final SimplePanel resultsP = new SimplePanel();
        final ClickHandler cl = new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                if (tx.getText().equals("")) {
                    Window.alert((String)QueryWidget.this.constants.PleaseEnterSomeSearchText());
                    return;
                }
                resultsP.clear();
                QueryPagedTable table = new QueryPagedTable(tx.getText(), archiveBox.getValue(), QueryWidget.this.clientFactory);
                resultsP.add((Widget)table);
            }
        };
        go.addClickHandler(cl);
        tx.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getCharCode() == '\r') {
                    cl.onClick(null);
                }
            }
        });
        criteria.add((Widget)ts);
        container.add((Widget)criteria);
        container.add((Widget)resultsP);
        advancedDisclosure.setContent((Widget)container);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void doMetaSearch() {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.constants.AttributeSearch());
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(true);
        VerticalPanel container = new VerticalPanel();
        VerticalPanel criteria = new VerticalPanel();
        final HashMap<String, MetaDataQuery> atts = new HashMap<String, MetaDataQuery>(){
            private static final long serialVersionUID = 510L;
            {
                this.put(QueryWidget.this.constants.CreatedBy(), new MetaDataQuery("drools:creator"));
                this.put(QueryWidget.this.constants.Format1(), new MetaDataQuery("drools:format"));
                this.put(QueryWidget.this.constants.Subject(), new MetaDataQuery("drools:subject"));
                this.put(QueryWidget.this.constants.Type1(), new MetaDataQuery("drools:type"));
                this.put(QueryWidget.this.constants.ExternalLink(), new MetaDataQuery("drools:relation"));
                this.put(QueryWidget.this.constants.Source(), new MetaDataQuery("drools:source"));
                this.put(QueryWidget.this.constants.Description1(), new MetaDataQuery("drools:description"));
                this.put(QueryWidget.this.constants.LastModifiedBy(), new MetaDataQuery("drools:lastContributor"));
                this.put(QueryWidget.this.constants.CheckinComment(), new MetaDataQuery("drools:checkinComment"));
            }
        };
        FormStyleLayout fm = new FormStyleLayout();
        for (String fieldName : atts.keySet()) {
            final MetaDataQuery q = (MetaDataQuery)atts.get(fieldName);
            final TextBox box = new TextBox();
            box.setTitle(this.constants.WildCardsSearchTip());
            fm.addAttribute(fieldName + ":", (Widget)box);
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent arg0) {
                    q.valueList = box.getText();
                }
            });
        }
        HorizontalPanel created = new HorizontalPanel();
        created.add((Widget)new SmallLabel(this.constants.AfterColon()));
        final DatePickerTextBox createdAfter = new DatePickerTextBox("");
        created.add((Widget)createdAfter);
        created.add((Widget)new SmallLabel("&nbsp;"));
        created.add((Widget)new SmallLabel(this.constants.BeforeColon()));
        final DatePickerTextBox createdBefore = new DatePickerTextBox("");
        created.add((Widget)createdBefore);
        fm.addAttribute(this.constants.DateCreated1(), (Widget)created);
        HorizontalPanel lastMod = new HorizontalPanel();
        lastMod.add((Widget)new SmallLabel(this.constants.AfterColon()));
        final DatePickerTextBox lastModAfter = new DatePickerTextBox("");
        lastMod.add((Widget)lastModAfter);
        lastMod.add((Widget)new SmallLabel("&nbsp;"));
        lastMod.add((Widget)new SmallLabel(this.constants.BeforeColon()));
        final DatePickerTextBox lastModBefore = new DatePickerTextBox("");
        lastMod.add((Widget)lastModBefore);
        fm.addAttribute(this.constants.LastModified1(), (Widget)lastMod);
        final SimplePanel resultsP = new SimplePanel();
        Button search = new Button(this.constants.Search());
        fm.addAttribute("", (Widget)search);
        search.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                resultsP.clear();
                try {
                    ArrayList<MetaDataQuery> metadata = new ArrayList<MetaDataQuery>();
                    metadata.addAll(atts.values());
                    QueryPagedTable table = new QueryPagedTable(metadata, this.getDate(createdAfter), this.getDate(createdBefore), this.getDate(lastModAfter), this.getDate(lastModBefore), false, QueryWidget.this.clientFactory);
                    resultsP.add((Widget)table);
                }
                catch (IllegalArgumentException e) {
                    ErrorPopup.showMessage(QueryWidget.this.constants.BadDateFormatPleaseTryAgainTryTheFormatOf0(ApplicationPreferences.getDroolsDateFormat()));
                }
            }

            private Date getDate(DatePickerTextBox datePicker) {
                try {
                    return datePicker.getDate();
                }
                catch (IllegalArgumentException e) {
                    datePicker.clear();
                    throw e;
                }
            }
        });
        criteria.add((Widget)fm);
        container.add((Widget)criteria);
        container.add((Widget)resultsP);
        advancedDisclosure.setContent((Widget)container);
        this.layout.add((Widget)advancedDisclosure);
    }
}

