/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Comparator;
import org.drools.guvnor.client.asseteditor.AfterAssetEditorCheckInEvent;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.RuleViewerWrapper;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.moduleeditor.ModuleEditorWrapper;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.client.rpc.TableDataRow;
import org.drools.guvnor.client.widgets.CheckinPopup;

public class VersionBrowser
extends Composite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private Image refresh;
    private FlexTable layout;
    private final String uuid;
    private final boolean isPackage;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public VersionBrowser(ClientFactory clientFactory, EventBus eventBus, String uuid, boolean isPackage) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.uuid = uuid;
        this.isPackage = isPackage;
        HorizontalPanel wrapper = new HorizontalPanel();
        ClickHandler clickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                VersionBrowser.this.clickLoadHistory();
            }
        };
        this.layout = new FlexTable();
        ClickableLabel vh = new ClickableLabel(this.constants.VersionHistory1(), clickHandler);
        this.layout.setWidget(0, 0, (Widget)vh);
        this.layout.getCellFormatter().setStyleName(0, 0, "metadata-Widget");
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.refresh = GuvnorImages.INSTANCE.Refresh();
        this.refresh.addClickHandler(clickHandler);
        this.layout.setWidget(0, 1, (Widget)this.refresh);
        formatter.setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        wrapper.setStyleName("version-browser-Border");
        wrapper.add((Widget)this.layout);
        this.layout.setWidth("100%");
        wrapper.setWidth("100%");
        this.initWidget((Widget)wrapper);
    }

    protected void clickLoadHistory() {
        this.showBusyIcon();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                VersionBrowser.this.loadHistoryData();
            }
        });
    }

    private void showBusyIcon() {
        this.refresh.setResource(images.searching());
    }

    protected void loadHistoryData() {
        AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
        assetService.loadItemHistory(this.uuid, (AsyncCallback<TableDataResult>)new GenericCallback<TableDataResult>(){

            public void onSuccess(TableDataResult table) {
                if (table == null || table.data.length == 0) {
                    VersionBrowser.this.layout.setWidget(1, 0, (Widget)new Label(VersionBrowser.this.constants.NoHistory()));
                    VersionBrowser.this.showStaticIcon();
                    return;
                }
                TableDataRow[] rows = table.data;
                Arrays.sort(rows, new Comparator<TableDataRow>(){

                    @Override
                    public int compare(TableDataRow r1, TableDataRow r2) {
                        Integer v2 = Integer.valueOf(r2.values[0]);
                        Integer v1 = Integer.valueOf(r1.values[0]);
                        return v2.compareTo(v1);
                    }
                });
                final ListBox history = new ListBox(true);
                for (TableDataRow row : rows) {
                    String s = VersionBrowser.this.constants.property0ModifiedOn1By23(row.values[0], row.values[2], row.values[4], row.values[1]);
                    history.addItem(s, row.id);
                }
                VersionBrowser.this.layout.setWidget(1, 0, (Widget)history);
                FlexTable.FlexCellFormatter formatter = VersionBrowser.this.layout.getFlexCellFormatter();
                formatter.setColSpan(1, 0, 2);
                Button open = new Button(VersionBrowser.this.constants.View());
                open.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        VersionBrowser.this.showVersion(history.getValue(history.getSelectedIndex()));
                    }
                });
                VersionBrowser.this.layout.setWidget(2, 0, (Widget)open);
                formatter.setColSpan(2, 1, 3);
                formatter.setHorizontalAlignment(2, 1, HasHorizontalAlignment.ALIGN_CENTER);
                VersionBrowser.this.showStaticIcon();
            }
        });
    }

    private void showVersion(final String versionUUID) {
        LoadingPopup.showMessage(this.constants.LoadingVersionFromHistory());
        if (this.isPackage) {
            ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
            moduleService.loadModule(versionUUID, (AsyncCallback<Module>)new GenericCallback<Module>(){

                public void onSuccess(Module conf) {
                    Image image = new Image(images.snapshot());
                    image.setAltText(ConstantsCore.INSTANCE.Snapshot());
                    FormStylePopup pop = new FormStylePopup(image, VersionBrowser.this.constants.VersionNumber0Of1(conf.getVersionNumber(), conf.getName()), 800);
                    ModuleEditorWrapper ed = new ModuleEditorWrapper(conf, VersionBrowser.this.clientFactory, VersionBrowser.this.eventBus, true);
                    ed.setWidth("100%");
                    ed.setHeight("100%");
                    pop.addRow((Widget)ed);
                    pop.show();
                }
            });
        } else {
            AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
            assetService.loadRuleAsset(versionUUID, (AsyncCallback<Asset>)new GenericCallback<Asset>(){

                public void onSuccess(final Asset asset) {
                    asset.setReadonly(true);
                    Image image = new Image(images.snapshot());
                    image.setAltText(ConstantsCore.INSTANCE.Snapshot());
                    final FormStylePopup pop = new FormStylePopup(image, VersionBrowser.this.constants.VersionNumber0Of1(asset.getVersionNumber(), asset.getName()), 800);
                    Button restore = new Button(VersionBrowser.this.constants.RestoreThisVersion());
                    restore.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            VersionBrowser.this.restore((Widget)event.getSource(), versionUUID, new Command(){

                                public void execute() {
                                    VersionBrowser.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(asset.getMetaData().getModuleName(), VersionBrowser.this.uuid));
                                    VersionBrowser.this.eventBus.fireEvent((GwtEvent)new AfterAssetEditorCheckInEvent(VersionBrowser.this.uuid, null));
                                    pop.hide();
                                }
                            });
                        }
                    });
                    RuleViewerWrapper viewer = new RuleViewerWrapper(VersionBrowser.this.clientFactory, VersionBrowser.this.eventBus, asset, true);
                    viewer.setWidth("100%");
                    viewer.setHeight("100%");
                    pop.addRow((Widget)restore);
                    pop.addRow((Widget)viewer);
                    pop.show();
                }
            });
        }
    }

    private void restore(Widget w, final String versionUUID, final Command refresh) {
        final CheckinPopup pop = new CheckinPopup(this.constants.RestoreThisVersionQ());
        pop.setCommand(new Command(){

            public void execute() {
                AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
                assetService.restoreVersion(versionUUID, VersionBrowser.this.uuid, pop.getCheckinComment(), (AsyncCallback<Void>)new GenericCallback<Void>(){

                    public void onSuccess(Void v) {
                        refresh.execute();
                    }
                });
            }
        });
        pop.show();
    }

    private void showStaticIcon() {
        this.refresh.setResource(images.refresh());
    }
}

