/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.modules;

import com.google.gwt.place.shared.Place;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.IsTreeItem;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.modules.Folder;
import org.drools.guvnor.client.explorer.navigation.modules.ModuleTreeItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModuleTreeSelectableItem;
import org.drools.guvnor.client.explorer.navigation.modules.ModulesTreeItemBaseView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageHierarchicalView;
import org.drools.guvnor.client.explorer.navigation.modules.PackageView;
import org.drools.guvnor.client.rpc.Module;

public abstract class ModulesTreeItemBase
implements IsWidget,
ModulesTreeItemBaseView.Presenter {
    protected PackageView packageHierarchy = new PackageHierarchicalView();
    protected ModulesTreeItemBaseView view;
    protected String perspectiveTypes;
    protected final ClientFactory clientFactory;

    public ModulesTreeItemBase(ClientFactory clientFactory, ModulesTreeItemBaseView view, String perspectiveTypes) {
        this.view = view;
        view.setPresenter(this);
        this.clientFactory = clientFactory;
        this.perspectiveTypes = perspectiveTypes;
        this.setUpRootItem();
    }

    protected void setUpRootItem() {
        this.fillModulesTree(this.view.addModulesTreeItem());
    }

    protected abstract void fillModulesTree(IsTreeItem var1);

    @Override
    public void onModuleSelected(Object userObject) {
        if (userObject instanceof Place) {
            this.clientFactory.getPlaceController().goTo((Place)userObject);
        }
    }

    @Override
    public SafeHtml getModuleTreeRootNodeHeader() {
        return this.clientFactory.getNavigationViewFactory().getModulesTreeRootNodeHeader(this.perspectiveTypes);
    }

    protected void addModules(Module[] packageConfigDatas, IsTreeItem treeItem) {
        for (Module packageConfigData : packageConfigDatas) {
            this.packageHierarchy.addPackage(packageConfigData);
        }
        Folder rootFolder = this.packageHierarchy.getRootFolder();
        for (Folder childFolder : rootFolder.getChildren()) {
            this.createModuleTreeItem(treeItem, childFolder);
        }
    }

    protected ModuleTreeItem createModuleTreeItem(IsTreeItem treeItem, Folder folder) {
        ModuleTreeItem mti = null;
        String folderName = folder.getFolderName();
        Module conf = folder.getPackageConfigData();
        mti = conf != null ? new ModuleTreeSelectableItem(this.clientFactory.getNavigationViewFactory(), this.view.addModuleTreeSelectableItem(treeItem, folderName), conf) : new ModuleTreeItem(this.clientFactory.getNavigationViewFactory(), this.view.addModuleTreeItem(treeItem, folderName));
        for (Folder childFolder : folder.getChildren()) {
            this.createModuleTreeItem(mti.getRootItem(), childFolder).getRootItem();
        }
        return mti;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

