/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class WorkspaceEditor
extends FormStylePopup {
    private TextBox name = new TextBox();
    private Command refresh;

    public WorkspaceEditor(Command refresh) {
        super(WorkspaceEditor.getImage(), ConstantsCore.INSTANCE.CreateNewStatus());
        this.refresh = refresh;
        this.addAttribute(ConstantsCore.INSTANCE.StatusName(), (Widget)this.name);
        Button ok = new Button(ConstantsCore.INSTANCE.OK());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                WorkspaceEditor.this.ok();
            }
        });
        this.addAttribute("", (Widget)ok);
    }

    private static Image getImage() {
        Image image = new Image(ImagesCore.INSTANCE.editCategory());
        image.setAltText(ConstantsCore.INSTANCE.EditCategory());
        return image;
    }

    void ok() {
        if ("".equals(this.name.getText())) {
            ErrorPopup.showMessage(ConstantsCore.INSTANCE.CanTHaveAnEmptyWorkspaceName());
        } else {
            this.createWorkspace(this.name);
        }
    }

    private void createWorkspace(final TextBox box) {
        LoadingPopup.showMessage(ConstantsCore.INSTANCE.CreatingStatus());
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.createWorkspace(box.getText(), new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                if (WorkspaceEditor.this.refresh != null) {
                    box.setText("");
                    LoadingPopup.close();
                    WorkspaceEditor.this.hide();
                    WorkspaceEditor.this.refresh.execute();
                }
            }
        });
    }

    void cancel() {
        this.hide();
    }
}

