/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.admin.widget;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.rpc.LogPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;

public class EventLogPresenter {
    private final EventLogView view;
    protected RepositoryServiceAsync repositoryService;

    public EventLogPresenter(RepositoryServiceAsync repositoryService, EventLogView view) {
        this.repositoryService = repositoryService;
        this.view = view;
        this.bind();
        this.setDataProvider();
    }

    public void bind() {
        this.view.getClearEventLogButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventLogPresenter.this.doClearEventLog();
            }
        });
        this.view.getRefreshEventLogButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EventLogPresenter.this.doRefreshEventLog();
            }
        });
    }

    private void doClearEventLog() {
        this.view.showClearingLogMessage();
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.cleanLog(new GenericCallback<Void>(){

            public void onSuccess(Void v) {
                EventLogPresenter.this.view.refresh();
                EventLogPresenter.this.view.hideClearingLogMessage();
            }
        });
    }

    private void doRefreshEventLog() {
        this.view.refresh();
    }

    private void setDataProvider() {
        this.view.setDataProvider(new AsyncDataProvider<LogPageRow>(){

            protected void onRangeChanged(HasData<LogPageRow> table) {
                PageRequest request = new PageRequest();
                request.setStartRowIndex(EventLogPresenter.this.view.getStartRowIndex());
                request.setPageSize(EventLogPresenter.this.view.getPageSize());
                EventLogPresenter.this.repositoryService.showLog(request, (AsyncCallback<PageResponse<LogPageRow>>)new GenericCallback<PageResponse<LogPageRow>>(){

                    public void onSuccess(PageResponse<LogPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    public static interface EventLogView
    extends IsWidget {
        public HasClickHandlers getClearEventLogButton();

        public HasClickHandlers getRefreshEventLogButton();

        public void setDataProvider(AsyncDataProvider<LogPageRow> var1);

        public void refresh();

        public void showClearingLogMessage();

        public void hideClearingLogMessage();

        public int getStartRowIndex();

        public int getPageSize();
    }
}

