/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.ResettableEventBus;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.NavigationItemBuilder;
import org.drools.guvnor.client.explorer.navigation.NavigationPanelView;
import org.drools.guvnor.client.perspective.ChangePerspectiveEvent;

public class NavigationPanel
implements ChangePerspectiveEvent.Handler,
IsWidget {
    private final NavigationPanelView view;
    private final ClientFactory clientFactory;
    private final ResettableEventBus eventBus;

    public NavigationPanel(ClientFactory clientFactory, EventBus eventBus) {
        this.view = clientFactory.getNavigationViewFactory().getNavigationPanelView();
        eventBus.addHandler(ChangePerspectiveEvent.TYPE, (EventHandler)this);
        this.eventBus = new ResettableEventBus((com.google.web.bindery.event.shared.EventBus)eventBus);
        this.clientFactory = clientFactory;
    }

    public void add(IsWidget header, IsWidget content) {
        this.view.add(header, content);
    }

    @Override
    public void onChangePerspective(ChangePerspectiveEvent changePerspectiveEvent) {
        this.view.clear();
        this.eventBus.removeHandlers();
        this.addNavigationItems(changePerspectiveEvent);
    }

    private void addNavigationItems(ChangePerspectiveEvent changePerspectiveEvent) {
        for (NavigationItemBuilder navigationItemBuilder : changePerspectiveEvent.getPerspective().getBuilders(this.clientFactory, (EventBus)this.eventBus)) {
            this.addNavigationItem(navigationItemBuilder);
        }
    }

    private void addNavigationItem(NavigationItemBuilder navigationItemBuilder) {
        if (navigationItemBuilder.hasPermissionToBuild()) {
            this.view.add(navigationItemBuilder.getHeader(), navigationItemBuilder.getContent());
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

