/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;

public class RulePackageSelector
extends Composite {
    public static String currentlySelectedPackage;
    private ListBox packageList;
    private boolean loadGlobalArea = false;

    public RulePackageSelector() {
        this(false);
    }

    public RulePackageSelector(boolean loadGlobalArea) {
        this.loadGlobalArea = loadGlobalArea;
        this.packageList = new ListBox();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                RulePackageSelector.this.loadPackageList();
            }
        });
        this.initWidget((Widget)this.packageList);
    }

    private void loadPackageList() {
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listModules((AsyncCallback<Module[]>)new GenericCallback<Module[]>(){

            public void onSuccess(Module[] list) {
                for (int i = 0; i < list.length; ++i) {
                    RulePackageSelector.this.packageList.addItem(list[i].getName(), list[i].getUuid());
                    if (currentlySelectedPackage == null || !list[i].getName().equals(currentlySelectedPackage)) continue;
                    RulePackageSelector.this.packageList.setSelectedIndex(i);
                }
                if (RulePackageSelector.this.loadGlobalArea) {
                    RulePackageSelector.this.packageList.addItem("globalArea", "nouuidavailable");
                }
                RulePackageSelector.this.packageList.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        currentlySelectedPackage = RulePackageSelector.this.getSelectedPackage();
                    }
                });
            }
        });
    }

    public String getSelectedPackage() {
        int index = this.packageList.getSelectedIndex();
        return this.packageList.getItemText(index);
    }

    public String getSelectedPackageUUID() {
        int index = this.packageList.getSelectedIndex();
        return this.packageList.getValue(index);
    }
}

