/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.drools.guvnor.client.common.AbstractRestrictedEntryTextBox;
import org.drools.guvnor.client.configurations.ApplicationPreferences;

public class DateTextBox
extends AbstractRestrictedEntryTextBox {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat DATE_FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public DateTextBox() {
        super(false);
    }

    public DateTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        if (!isOnFocusLost) {
            return true;
        }
        boolean isValid = true;
        try {
            DATE_FORMATTER.parseStrict(value);
        }
        catch (IllegalArgumentException iae) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }

    @Override
    protected String makeValidValue(String value) {
        return DATE_FORMATTER.format(new Date());
    }
}

