/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.DatePicker;
import org.drools.guvnor.client.common.DatePickerPopUp;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;

public class DatePickerTextBox
extends DatePicker {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);

    public DatePickerTextBox(String selectedDate) {
        this(selectedDate, defaultFormat);
    }

    public DatePickerTextBox(String selectedDate, String visualFormat) {
        this.solveVisualFormat(visualFormat);
        this.visualFormatFormatter = DateTimeFormat.getFormat((String)this.visualFormat);
        this.datePickerPopUp = new DatePickerPopUp(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    Date date = DatePickerTextBox.this.fillDate();
                    DatePickerTextBox.this.textWidget.setText(DatePickerTextBox.this.visualFormatFormatter.format(date));
                    DatePickerTextBox.this.valueChanged();
                    DatePickerTextBox.this.makeDirty();
                    DatePickerTextBox.this.datePickerPopUp.hide();
                }
                catch (Exception e) {
                    Window.alert((String)DatePickerTextBox.this.constants.InvalidDateFormatMessage());
                }
            }
        }, this.visualFormatFormatter);
        ImageButton select = new ImageButton(GuvnorImages.INSTANCE.Edit());
        select.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DatePickerTextBox.this.datePickerPopUp.setPopupPosition(DatePickerTextBox.this.textWidget.getAbsoluteLeft(), DatePickerTextBox.this.textWidget.getAbsoluteTop() + 20);
                if (DatePickerTextBox.this.textWidget.getText() != null && "".equals(DatePickerTextBox.this.textWidget.getText())) {
                    DatePickerTextBox.this.textWidget.setText(DatePickerTextBox.this.visualFormatFormatter.format(new Date()));
                }
                DatePickerTextBox.this.datePickerPopUp.setDropdowns(DatePickerTextBox.this.visualFormatFormatter, DatePickerTextBox.this.textWidget.getText());
                DatePickerTextBox.this.datePickerPopUp.show();
            }
        });
        if (selectedDate != null && !selectedDate.equals("")) {
            this.textWidget.setText(selectedDate);
            try {
                this.visualFormatFormatter.parse(selectedDate);
            }
            catch (Exception e) {
                selectedDate = null;
            }
        }
        this.textWidget.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TextBox box = (TextBox)event.getSource();
                DatePickerTextBox.this.textWidget.setText(box.getText());
                DatePickerTextBox.this.valueChanged();
                DatePickerTextBox.this.makeDirty();
                DatePickerTextBox.this.datePickerPopUp.hide();
            }
        });
        this.panel.add((Widget)this.textWidget);
        this.panel.add((Widget)select);
        this.initWidget((Widget)this.panel);
    }

    public void clear() {
        this.textWidget.setText("");
    }
}

